/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@wakaba.jp                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef _KITAWRITEDIALOG_H_
#define _KITAWRITEDIALOG_H_

#include <qwidget.h>
#include <kio/job.h>
#include "kitawritedialogbase.h"

template<class type> class QPtrList;
class KitaWriteDialogPrivate;
class KitaWriteDialog;

/**
 * 
 * Hideki Ikemoto
 **/
class KitaWriteDialog : public KitaWriteDialogBase
{
  Q_OBJECT
public:
  struct PostInfo {
    PostInfo() {
	 bbscgi = "/test/bbs.cgi";
	 submit = "%91%53%90%d3%94%43%82%f0%95%89%82%a4%82%b1%82%c6%82%f0%8f%b3%91%f8%82%b5%82%c4%8f%91%82%ab%8d%9e%82%de";
    };
    QString host;
    QString bbscgi;
    QString name;
    QString mail;
    QString body;
    QString bbs;
    QString key;
    QString time;
    QString submit;
    QString cookie;
  };

  KitaWriteDialog(QWidget *parent=0, const char *name=0 );
  virtual ~KitaWriteDialog();
  QString name();
  QString mail();
  QString body();

  virtual bool error(){ return false; };

  static KitaWriteDialog * open( const PostInfo& info );
  static bool checkPostInfo( const PostInfo& info );

public slots:
  void postMessage();

signals:
  void postStarted( KIO::Job * );
  void postFinished( KIO::Job * );
  void postResponse( const QString& response, const KURL& bbscgi = KURL() );

protected:
  PostInfo m_postInfo;

private:
  void fetchPostInfo( PostInfo * storage );

  QCString m_array;
  bool m_error;
  static KitaWriteDialogPrivate * s_private;

private slots:
  void slotRecieveData(KIO::Job *, const QByteArray &);
  void slotPostFinished(KIO::Job *);

};

class KitaWriteDialogPrivate
{
public:
   QPtrList<KitaWriteDialog> m_heaplist;
};
#endif
