/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@wakaba.jp                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "kitawritedialog.h"
#include "qcp932codec.h"

#include <qlineedit.h>
#include <qtextedit.h>
#include <qpushbutton.h>
#include <qlabel.h>

#include <kio/job.h>

KitaWriteDialogPrivate * KitaWriteDialog::s_private = 0;

KitaWriteDialog::KitaWriteDialog(QWidget *parent, const char *name)
  : KitaWriteDialogBase(parent, name)
{
  //QFont font = font();
  QFont font;
  font.setFamily("Gothic [Mona]");
  font.setPixelSize( 12 );
  bodyText->setFont( font );
  nameLine->setFont( font );
  nameLabel->setFont( font );
  mailLine->setFont( font );
  mailLabel->setFont( font );
}

KitaWriteDialog::~KitaWriteDialog()
{
}

QString KitaWriteDialog::name()
{
  return nameLine->text();
}

QString KitaWriteDialog::mail()
{
  return mailLine->text();
}

QString KitaWriteDialog::body()
{
  return bodyText->text();
}

void KitaWriteDialog::fetchPostInfo( PostInfo * storage )
{
  storage->name = name();
  storage->mail = mail();
  storage->body = body();
}

KitaWriteDialog *  KitaWriteDialog::open( const PostInfo& info )
{
  if ( ! checkPostInfo( info ) ) return 0;
  if ( ! s_private ) {
    s_private = new KitaWriteDialogPrivate;
    if ( ! s_private ) return 0;
  }

  KitaWriteDialog * new_dlg = new KitaWriteDialog;
  if ( ! new_dlg ) return 0;
  
  new_dlg->m_postInfo = info;
  s_private->m_heaplist.append( new_dlg );
  
  new_dlg->connect( new_dlg->buttonOk, SIGNAL( clicked() ), new_dlg, SLOT( postMessage() ) );

  return new_dlg;
}

void KitaWriteDialog::postMessage()
{
  fetchPostInfo( &m_postInfo );
  if ( ! checkPostInfo( m_postInfo ) )
	return ;

  KURL bbscgi;
  bbscgi.setProtocol( "http" );
  bbscgi.setHost( m_postInfo.host );
  bbscgi.setPath( m_postInfo.bbscgi );

  //int mib = QTextCodec::codecForName("CP932")->mibEnum();
  QCp932Codec codec;
  int mib = codec.mibEnum();
  QString postStr;
  (postStr += "submit=") += m_postInfo.submit;
  (postStr += "&subject=");
  (postStr += "&FROM=") += KURL::encode_string(m_postInfo.name, mib);
  (postStr += "&mail=") += KURL::encode_string(m_postInfo.mail, mib);
  (postStr += "&MESSAGE=") += KURL::encode_string(m_postInfo.body, mib);
  (postStr += "&bbs=") += m_postInfo.bbs;
  (postStr += "&key=") += m_postInfo.key;
  (postStr += "&time=") += m_postInfo.time;

  printf("query: %s\n", postStr.latin1());
  m_array.resize(0);

  KIO::TransferJob * job = KIO::http_post(bbscgi, postStr.utf8(), true);
  job->addMetaData("content-type", "Content-type: application/x-www-form-urlencoded");
  job->addMetaData("referrer", QString("http://%1/%2/").arg(m_postInfo.host).arg(m_postInfo.bbs) );

  if ( ! m_postInfo.cookie.isEmpty() )
	  job->addMetaData("cookie", m_postInfo.cookie.prepend("Cookie: "));

  emit postStarted( job );

  connect( job, SIGNAL( data(KIO::Job*, const QByteArray&) ),
	   this, SLOT( slotRecieveData(KIO::Job *, const QByteArray &) ) );
  connect( job, SIGNAL( result(KIO::Job *) ),
	   this, SLOT( slotPostFinished(KIO::Job *) ) );
}

bool KitaWriteDialog::checkPostInfo( const PostInfo& info )
{
  if ( info.host.isEmpty() || info.bbscgi.isEmpty()
     || info.bbs.isEmpty() || info.key.isEmpty() )
	return false;

  return true;
}

void KitaWriteDialog::slotRecieveData(KIO::Job *, const QByteArray &data)
{
  m_array.append( data.data() );
}

void  KitaWriteDialog::slotPostFinished(KIO::Job *job)
{
  QString response = QTextCodec::codecForName("sjis")->toUnicode( m_array );
  QCString output = QTextCodec::codecForName("eucJP")->fromUnicode( response );
  printf("response:\n%s\n", output.data() );
  emit postFinished( job );
  KURL bbscgi;
  bbscgi.setProtocol( "http" );
  bbscgi.setHost( m_postInfo.host );
  bbscgi.setPath( m_postInfo.bbscgi );
  emit postResponse( response, bbscgi );

  m_array.resize(0);

  int idx = s_private->m_heaplist.find( this );
  if ( idx != -1 ) 
    delete this;
}

// vim:sw=2:
