/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@wakaba.jp                                                       *
 *   linux 󥫥פ餰ο                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <qfile.h>
#include <qtextstream.h>
#include <qtextcodec.h>
#include <qlayout.h>
#include <qtoolbutton.h>
#include "qcp932codec.h"
#include <qsjiscodec.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qprogressdialog.h>
#include <qvaluestack.h>

#include <time.h>

#include <kurl.h>
#include <kio/netaccess.h>
#include <kio/slaveconfig.h>
#include <kio/jobclasses.h>
#include <kio/scheduler.h>

#include <khtml_part.h>
#include <khtmlview.h>
#include <dom/html_element.h>
#include <dom/html_inline.h>
#include <dom/html_base.h>

#include <kglobal.h>
#include <kconfig.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kaction.h>

#include "kitathreadview.h"
#include "kitawritedialog.h"

#include <qmessagebox.h>

static QString linkURL(QString);

KitaThreadView::KitaThreadView(QWidget *parent, const char *name)
    : KitaThreadViewBase(parent, name)
    , m_parent( parent )
    , m_currentJob( 0 )
    , m_labelMaxLength( 60 )
{
  threadPart = new KHTMLPart(threadFrame);
  QHBoxLayout* aLayout = new QHBoxLayout(threadFrame);
  aLayout->addWidget(threadPart->view());

  {
    threadPart->setStandardFont("Gothic [Mona]");
    threadPart->setZoomFactor(120); // 12px;    
#if 0 // provides you with mona font info.
    QString info;
    info +=  view()->font().family();
    info +="\n";
    info +=  QString("size: %1pt %2px\n").arg( view()->font().pointSizeFloat() ).arg( view()->font().pixelSize() );
    QMessageBox::information( 0, "", info );
#endif
  }
  
  {
    SearchButton->setPixmap( SmallIcon("find") );
    HighLightButton->setPixmap( SmallIcon("idea") );
  }

  setAcceptDrops( true ); // DND Drop eneble: 2nd stage. - enable on "KitaThreadView" widget and disable on the others(child widgets of "KitaThreadView").
  threadFrame->setAcceptDrops( false ); // don't treat Drop event on child.
  threadPart->view()->setAcceptDrops( false ); // don't treat Drop event on child.

  threadPart->enableMetaRefresh( false ); //disable <meta refresh="...">


  connect( writeButton, SIGNAL(clicked()), SLOT(slotWriteButtonClicked()));
  connect( threadPart, SIGNAL( nodeActivated(const DOM::Node &) ), SLOT( slotDOMNodeActivated(const DOM::Node &) ) );
  connect( threadPart, SIGNAL( onURL(const QString&) ), SLOT( slotOnURL(const QString&) ) );
  connect( SearchButton, SIGNAL( clicked() ), SLOT( slotSearchButton() ) );
  connect( SearchCombo, SIGNAL( activated(int) ), SLOT( slotSearchButton() ) );
  connect( HighLightButton, SIGNAL( toggled(bool) ), SLOT( slotHighLightenButton(bool) ) );
  connect( GobackAnchorButton, SIGNAL( clicked() ), SLOT( gobackAnchor() ) );

  KParts::BrowserExtension * ext = threadPart->browserExtension();
  connect( ext, SIGNAL( openURLRequest(const KURL&, const KParts::URLArgs&) ),
                 SLOT( slotOpenURLRequest(const KURL&, const KParts::URLArgs&) ) );
      		//SIGNAL( openURLRequest(const KURL&, const KParts::URLArgs&) ) );
  connect( ext, SIGNAL( createNewWindow (const KURL&, const KParts::URLArgs&) ),
      		SIGNAL( createNewWindow (const KURL&, const KParts::URLArgs&) ) );
  connect( ext, SIGNAL( setLocationBarURL(const QString &) ),
      		SIGNAL( setLocationBarURL(const QString &) ) );
  connect( ext, SIGNAL( enableAction(const char*, bool) ),
      		SIGNAL( enableAction(const char*, bool) ) );

  connect( ext, SIGNAL( popupMenu(KXMLGUIClient *, const QPoint&, const KURL&, const QString&, mode_t) ),
      this, SLOT( slotPopupMenu(KXMLGUIClient *, const QPoint&, const KURL&, const QString&, mode_t) ) );

}

KitaThreadView::~KitaThreadView() {}

QString KitaThreadView::threadSubject() const
{
  return m_subject;
}

void KitaThreadView::slotDOMNodeActivated(const DOM::Node &node)
{
  { //process Anchor tags. Anchor tags not proccessed here cause 'emit KParts::BrowserExtention::openURLRequest()'
    DOM::HTMLAnchorElement anchor = node;

    if ( ! anchor.href().isEmpty() )
    {
      printf("  AnchorNodeActivated:: \n" );
    } // end: anchor.href().isEmpty()
  } // end of Anchor tags. 
}

void KitaThreadView::slotShowThread(const KURL& _datURL, const KURL& _boardURL, const QString& boardName)
{
  { //reset member variables associated with a thread.
    m_prevquery = "";
    m_nextHit = 0;
    m_hitcount = 0;
    m_writeResult = "";
    m_threadData = "";
    m_subject = "";
    m_contentsBody = DOM::HTMLBodyElement();
    m_pointStack.clear();
  }

  if ( _datURL.protocol() != "k2ch" ) { 
    KIO::SlaveConfig::self()->setConfigData("http", _datURL.host() ,
                                          "UserAgent", "Monazilla/1.00 (test)");
  }
  m_datURL = _datURL;
  m_boardURL = _boardURL;
  m_boardID = m_boardURL.fileName();
  m_datName = m_datURL.fileName().section('.', 0, 0);
  m_threadURL = KURL(m_boardURL, QString("../test/read.cgi/") + QString(m_boardURL.filename()) + QString("/") + QString( m_datURL.filename().section('.',0) ) );
  m_boardName = boardName;

  KIO::TransferJob* job = KIO::get(m_datURL, true, true);
  m_currentJob = job;

  connect(job, SIGNAL(data(KIO::Job*, const QByteArray&)),
          SLOT(slotReceiveThreadData(KIO::Job*, const QByteArray&)));
  connect(job, SIGNAL(result(KIO::Job*)), SLOT(slotThreadResult(KIO::Job*)));
  connect(job, SIGNAL(redirection(KIO::Job *, const KURL&) ), SLOT(slotRedirection(KIO::Job *, const KURL&) ) );

  // use 'HTTP-Headers' metadata.
  job->addMetaData("PropagateHttpHeader", "true");
}

void KitaThreadView::slotRedirection(KIO::Job *, const KURL & newURL)
{
  printf("  Redirected to newURL: %s\n", newURL.url().latin1() );
  m_datURL = newURL;
  emit setLocationBarURL(newURL.url());
}

void KitaThreadView::slotReceiveThreadData(KIO::Job*, const QByteArray& data)
{
  QCString cstr(data.data(), data.size()+1);
  m_threadData.append(cstr);
}

void KitaThreadView::slotThreadResult(KIO::Job* job)
{
  m_currentJob = 0;
  if(job->error()) {
    job->showErrorDialog();
    return;
  }

  QCp932Codec codec;
  QTextStream stream(m_threadData, IO_ReadOnly);
  stream.setCodec(&codec);
  QString line;
  QString text;
  int num = 1;

  // parse HTTP headers
  QStringList headerList = QStringList::split("\n", job->queryMetaData("HTTP-Headers"));
  QRegExp regexp("Date: (...), (..) (...) (....) (..:..:..) .*");
  QString dateStr = headerList.grep(regexp)[0];
  if(regexp.search(dateStr) == -1) {
    // invalid date format
    serverTime = time(NULL);
  } else {
    // I hate this format ;p
    QString usLocalDateStr = regexp.cap(1) + " " + regexp.cap(3) + " " +
                             regexp.cap(2) + " " + regexp.cap(5) + " " + regexp.cap(4);

    // 1970/01/01 00:00:00 GMT
    QDateTime zeroTime(QDate(1970, 1, 1), QTime(0, 0));
    serverTime = zeroTime.secsTo(QDateTime::fromString(usLocalDateStr));
  }

  int total = m_threadData.length();
  int step = 0;
  int divide = total / ( 100 / 5 );
  int next = divide;
  QProgressDialog * progress = new QProgressDialog( m_parent );
  progress->setTotalSteps( static_cast<int>(total * 0.7) );
  progress->setLabelText( "Parse DAT file.....");
  progress->show();
  while(!stream.atEnd()) {
    line = stream.readLine();
    QStringList list = QStringList::split("<>", line, true);

    if(list.size() != 5) {
      // probably eof
      break;
    }
    QString name = list[0];
    QString address = list[1];
    QString dateId = list[2];
    QString body = list[3];
    QString subject = list[4];

    if(num == 1) {
      m_subject = subject;
      {
	QString disp( m_subject );
	if ( ! m_boardName.isEmpty() ) { disp.prepend( QString("[%1]").arg(m_boardName) ); }
	disp.truncate( m_labelMaxLength );
	subjectLabel->setText( disp );
      }
      text += "<html><head>";
      text += "</head><body>";
    }
    text += "<dl><dt>";
    text += "<span id=\"";
    text += QString::number(num);
    text += "\"/>";
    text += QString::number(num);
    text += " ";
    if(address != "") {
      text += "<a href='mailto:" + address + "' title='" + address + "'>" + name + "</a>";
    } else {
      text += name;
    }
    text += " ";
    text += dateId;
    text += "</dt><dd>";
    text += linkURL(body);
    text += "<br/><br/></dd></dl>"; // Using '/>' is Recommended for performance reasons.

    num++;
    if( (step+=line.length()) > next ) {
      progress->setProgress( step );
      next += divide;
    }
  }
  delete progress;
  m_rescount = num - 1;

  {
    int target;
    for ( target = 1; target < m_rescount; target += 100 )
      text += QString(" <a href=\"#%1\">%3</a> ").arg(target).arg(target);
    text += "<br/>";
  }
#if 0
  text += QString("<a href=\"%1#%2\">check new one.</a>").arg( m_datURL.url() ).arg( m_rescount );
#endif
  text += "</body></html>";

  slotDisplayContents(text, m_datURL );
  if ( HighLightButton->isOn() ) {
    HighLightButton->toggle();
  }
  m_contentsBody = threadPart->htmlDocument().body();
  m_threadData.truncate(0);

  if ( m_datURL.hasRef() ) {
    if ( ! gotoAnchor( m_datURL.encodedHtmlRef()) )
      gotoAnchor( m_datURL.htmlRef() );
  } else {
    gotoAnchor( QString().setNum(m_rescount) );
  }
  m_pointStack.clear();
  KHTMLView * view = threadPart->view();
  m_pointStack.push( QPoint( view->contentsX(), view->contentsY() ) );

  emit showThreadCompleted();
}

void KitaThreadView::slotDisplayContents(const QString& input, const KURL& url)
{
  printf("    begin Display: %s\n", url.url().latin1() );
  threadPart->begin( url );
  threadPart->write( input );
  threadPart->end();
  if ( ! url.isEmpty() ) emit setLocationBarURL(url.url());
}

void KitaThreadView::slotWriteButtonClicked()
{
  KitaWriteDialog dialog;

  QSjisCodec cp932Codec;
  KURL bbscgiURL = KURL(m_boardURL, "../test/bbs.cgi");
  bbscgiURL.setProtocol( "http" );

  KitaWriteDialog::PostInfo info;
  info.host = bbscgiURL.host();
  info.bbs = m_boardID;
  info.key = m_datName;
  info.time = QString("%1").arg(serverTime);
  QDialog * new_dialog = KitaWriteDialog::open( info );
  connect( new_dialog, SIGNAL( postResponse(const QString&, const KURL&) ),
      	   this, SLOT( slotDisplayContents(const QString&, const KURL&) ) );
  new_dialog->show(); //work asynchronus.

#if 0
  if(dialog.exec() != QDialog::Accepted)
    return;

  QString postStr;
  int cp932MIB = cp932Codec.mibEnum();
  QTextStream stream(&postStr, IO_WriteOnly);
  QString name = KURL::encode_string(dialog.name(), cp932MIB);
  QString mail = KURL::encode_string(dialog.mail(), cp932MIB);
  QString body = KURL::encode_string(dialog.body(), cp932MIB);

  stream << "submit=%91%53%90%d3%94%43%82%f0%95%89%82%a4%82%b1%82%c6"; // zennsekininnwooukoto
  stream << "%82%f0%8f%b3%91%f8%82%b5%82%c4%8f%91%82%ab%8d%9e%82%de&"; // wosyoudakusitekakikomu
  stream << "subject=&";
  stream << "FROM=" << name << "&";
  stream << "mail=" << mail << "&";
  stream << "MESSAGE=" << body << "&";
  stream << "bbs=" << m_boardID << "&";
  stream << "key=" << m_datName << "&";
  stream << "time=" << serverTime;

  KIO::TransferJob* job = KIO::http_post(bbscgiURL, postStr.utf8(), true);

  // see kdelibs/kioslave/http/http.cc:2216
  job->addMetaData("content-type", "Content-type: application/x-www-form-urlencoded");

  job->addMetaData("referrer", KURL(m_boardURL,"./index2.html").prettyURL());

  connect(job, SIGNAL(data(KIO::Job*, const QByteArray&)),
          SLOT(slotReceiveWriteResult(KIO::Job*, const QByteArray&)));
  connect(job, SIGNAL(result(KIO::Job*)), SLOT(slotWriteResult(KIO::Job*)));
#endif
}

void KitaThreadView::slotReceiveWriteResult(KIO::Job *,  const QByteArray & data)
{
  QCString cstr(data.data(), data.size()+1);
  m_writeResult += cstr;
}

void KitaThreadView::slotWriteResult(KIO::Job* job)
{
  if(job->error()) {
    job->showErrorDialog();
  } else {
    QSjisCodec codec;
    QTextStream stream(m_writeResult, IO_ReadOnly);
    stream.setCodec(&codec);

    threadPart->begin();
    threadPart->write( m_writeResult.data(), m_writeResult.size() );
    threadPart->end();
    qDebug("#%s#", (const char *)stream.read().local8Bit());
    m_writeResult.truncate(0);
  }
}

void KitaThreadView::slotCanceled(KIO::Job*)
{
}

void KitaThreadView::slotSearchButton()
{
  insertSearchCombo();
  QStringList list = parseSearchQuery( SearchCombo->currentText() );
  searchNext( list );
}

void KitaThreadView::slotHighLightenButton(bool yes)
{
  insertSearchCombo();
  QStringList list = parseSearchQuery( SearchCombo->currentText() );
  highLighten( yes, list );
}

void KitaThreadView::insertSearchCombo()
{
  int count;
  bool found = false;

  for( count = 0; count < SearchCombo->count(); ++count ) {
    if ( SearchCombo->text( count ) ==  SearchCombo->currentText() ) {
      found = true;
      break;
    }
  }
  if ( ! found ) SearchCombo->insertItem( SearchCombo->currentText() );
}

QStringList KitaThreadView::parseSearchQuery(const QString &input)
{
  QStringList tmp = QStringList::split( ' ', input );
  QStringList ret_list;
  QRegExp truncSpace("\\s*$");
  QStringList::iterator it = tmp.begin();
  for( ; it != tmp.end(); ++it )
    ret_list += (*it).remove( truncSpace );
  return ret_list;
}

void KitaThreadView::searchNext(const QStringList &query)
{
  if ( query.isEmpty() ) return;
  if ( ! HighLightButton->isOn() ) {
    HighLightButton->toggle();
    m_nextHit = 0; //A next jump-search target reset to '0'.
    // Process works asynchronusly. So Firstly, we don't do jump-search as a simple solution.
    return;
  }
  if ( query != m_prevquery ) {
    highLighten( true, query );
    m_nextHit = 0; //A next jump-search target reset to '0'.
    return;
  }
    
  gotoAnchor( QString("highlight%1").arg(m_nextHit)  );
  ++m_nextHit;
  if ( !( m_nextHit < m_hitcount ) ) m_nextHit = 0;
}

void KitaThreadView::highLighten(bool yes, const QStringList &query)
{
  if ( ! yes ) {
    threadPart->setUserStyleSheet( QString("") );
    return;
  }

  // Use style sheet to highlighten.
  QString highlightCSS( ".highlight { color: %1; background: %2; } ");
#if 0
  QColorGroup cg = threadPart->view()->colorGroup();
  highlightCSS = highlightCSS.arg( cg.highlightedText().name() ).arg( cg.highlight().name()  );
#else
  highlightCSS = highlightCSS.arg( "yellow" ).arg( "black" );
#endif
  threadPart->setUserStyleSheet( highlightCSS );
  

  if ( m_prevquery == query ) return;
  m_prevquery = query;
  if ( query.isEmpty() ) return;

  threadPart->htmlDocument().setBody( m_contentsBody );
  DOM::NodeList nodes;
  m_hitcount = 0;
  nodes = threadPart->document().getElementsByTagName("body");
  highLightenNodes( nodes, query );
  threadPart->setUserStyleSheet( highlightCSS );
}

QStringList KitaThreadView::lt_gt_spliter( const QString & input )
{
  QStringList lt_gt_splitted;
  QRegExp lt_gt("[<>]");
  int start = 0;
  int end = 0;
  while ( (end = input.find(lt_gt, end+1)) != -1 ) {
    if ( input.at(end) == '<' ) {
      lt_gt_splitted += input.mid( start, end-start );
      start = end;
    } else
    if ( input.at(end) == '>' ) {
      lt_gt_splitted += input.mid( start, end+1-start );
      start = end + 1;
    } else QMessageBox::warning( 0, "", "KitaThreadView::lt_gt_spliter()\n !!Bug!! Not Match.\n Will you contact with authors?");
  }
  lt_gt_splitted += input.mid( start );
  return lt_gt_splitted;
}

void KitaThreadView::highLightenNodes(DOM::NodeList nodes, const QStringList &query)
{
  for ( unsigned int count = 0; count < nodes.length(); ++count ) {
    DOM::HTMLElement dd = nodes.item(count);
    //printf(" dd %d: %s\n", count, dd.innerHTML().string().latin1() );
    QStringList lt_gt_split = lt_gt_spliter( dd.innerHTML().string() );

    QProgressDialog progress(m_parent);
    progress.setLabelText("Searching...");
    progress.setTotalSteps( lt_gt_split.size() );
    progress.show();
    int step = 0;
    int divide = lt_gt_split.size() / ( 100 / 5 );
    int next = divide;

    //loop order not optimized. Need optim. that also needs any codes & members?
    QStringList::iterator it_msg = lt_gt_split.begin();
    for( ; it_msg != lt_gt_split.end(); ++it_msg ) 
    {
      QStringList::const_iterator it = query.begin(); 
      for( ; it != query.end(); ++it )
      {
	int pos = 0;
	QString message = *it_msg;
	//printf("dd %d: %s\n", count, (*it_msg).latin1() );
	if( message.at(0) == '<' ) continue;
	while ( (pos = (*it_msg).find(*it, pos)) != -1 ) {
	  //QMessageBox::information( 0, "Hit!",  QString( "pos: %1 (length: %2)\nhitcount: %4\nstring:\n%3").arg(pos).arg((*it).length()).arg(message).arg(m_hitcount) );
	  QString replace = QString("<font class=\"highlight\" id=\"highlight%2\">%1</font>").arg(*it).arg( m_hitcount );
	  message.replace(pos, (*it).length(), replace);
	  //printf("dd %d: replaced:: %s\n", count, message.latin1() );
	  pos += replace.length();
	  lt_gt_split.insert( it_msg, message );
	  it_msg = lt_gt_split.remove( it_msg );
	  --it_msg;
	  ++m_hitcount;
	}
      }
      if( ++step > next ) {
	progress.setProgress( step );
	next += divide;
      }
    }

    dd.setInnerHTML( lt_gt_split.join(" ") );

  }
}

void KitaThreadView::slotOnURL(const QString& url)
{
  emit signalChangeStatusbar(url);
}

static QString linkURL(QString str)
{
  QString ret;
  // see RFC 1738.
  QRegExp url_rx("(h?ttp://([-.0-9a-zA-Z]+(/[;:@&=$-_.+!*'(),%~/?#0-9a-zA-Z]*)?))");
  
  int i;
  while ((i = str.find(url_rx)) != -1) {
    if (i == 0) {
      // starts with URL.
      ret += "<a href='http://";
      ret += url_rx.cap(2);
      ret += "'>";
      ret += url_rx.cap(1);
      ret += "</a>";
      str.remove(0, url_rx.cap(1).length());
    } else {
      ret += str.left(i);
      str.remove(0, i);
    }
  }
  ret += str;
  return ret;
}

bool KitaThreadView::gotoAnchor( const QString &name )
{
  KHTMLView * view = threadPart->view();
  m_pointStack.push( QPoint( view->contentsX(), view->contentsY() ) );
  return threadPart->gotoAnchor( name );
}

bool KitaThreadView::gobackAnchor()
{
  QPoint p = m_pointStack.pop();
  if ( m_pointStack.isEmpty() ) m_pointStack.push( p );
  threadPart->view()->setContentsPos( p.x(), p.y()  );
  return true;
}

void KitaThreadView::slotPopupMenu( KXMLGUIClient *client, const QPoint &global, const KURL &url, const QString &mimeType, mode_t mode)
{
  KActionCollection * collection = client->actionCollection();
  KAction * action;
  action = new KAction( i18n("goback anchor"), SmallIcon("idea"), KShortcut(), this, SLOT( gobackAnchor() ), collection, "goback_anchor" );
  printf("  KitaThreadView::slotPopupMenu() %p\n", action);
  emit popupMenu(client, global, url, mimeType, mode);
}

void KitaThreadView::slotOpenURLRequest(const KURL& url, const KParts::URLArgs& args)
{
  printf(" openURLRequest:: orgURL %s\n", url.url().latin1() );
  if ( url.url().at(0) == '#' ) {
    gotoAnchor( url.ref() );
    return;
  }
  KURL datURL = filterReadCGI( url );
  if ( datURL.host() == m_datURL.host()
    && datURL.path() == m_datURL.path() )
  {
    if ( datURL.hasRef() ) gotoAnchor( datURL.ref() );
    return;
  }
  emit openURLRequest(datURL, args);
}
    
KURL KitaThreadView::filterReadCGI(const KURL& url)
{
  KURL  newURL = url;
  if ( url.path().contains("/test/read.cgi") ) {
    newURL.setProtocol( m_datURL.protocol() );
    QString tmp = url.path().section("/test/read.cgi", 1);
    //printf("    tmp: %s\n", tmp.latin1() );

    QString newPath = QString( "/%1/dat/%2.dat" )
               .arg( tmp.section('/', 1, 1) )
	       .arg( tmp.section('/', 2, 2) );
    newURL.setPath( newPath );
    //printf("    newPath: %s\n", newPath.latin1() );

    QString refBase = tmp.section('/', 3);
    if ( ! refBase.isEmpty() ) {
      QString newRef =  refBase.section('-', 0, 0);
      if( ! newRef.isEmpty() ) newURL.setRef( newRef );
      else if ( refBase.at(0) == '-' ) newURL.setRef("1");
      else newURL.setRef( refBase );
    }
  }
  printf("    newURL: %s\n", newURL.url().latin1() );
  return newURL;
}
// vim:sw=2:
