/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@wakaba.jp                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef _KITASUBJECTVIEW_H_
#define _KITASUBJECTVIEW_H_

#include <qwidget.h>
#include <kurl.h>
#include "kitasubjectviewbase.h"

class Kita;
class KListViewItem;

/**
 * 
 * Hideki Ikemoto
 **/
class KitaSubjectView : public KitaSubjectViewBase
{
  Q_OBJECT

public:
  KitaSubjectView(QWidget *parent, const char *name=0);
  ~KitaSubjectView();
public slots:
  void reloadSubject();
  void loadThread(QListViewItem* item);
  void slotLoadBoard(const KURL& url, const QString& boardName);
  void slotHideButton(bool on);
private: // Private attributes
  KURL m_boardURL;
  QString m_boardName;
  void insertSearchCombo();
  QStringList parseSearchQuery(const QString &input);
  void searchNext(const QStringList &input);
  QStringList m_prevquery;
  void searchAll(const QStringList &query);
  int m_nextHitIndex;
  QValueList<KListViewItem*> m_hitList;
signals:
  void signalShowThread(const KURL& datURL, const KURL& boardURL, const QString& boardName);
  void signalSubjectListClicked(QListViewItem* item);
private slots:
  void slotSearchButton();
};

#endif
