// $Id: k2ch.cpp,v 1.2 2003/03/25 15:19:16 ikemo Exp $

#include <config.h>

#include <stdlib.h>
#include <fcntl.h>
#include <sys/stat.h>

#include <klocale.h>
#include <kglobal.h>
#include <kinstance.h>
#include <kconfig.h>
#include <kdeversion.h>

#include <qstring.h>
#include <qregexp.h>
#include <qdom.h>

#include "k2ch.h"
#include <kio/global.h>
#include <kio/http.h>
#include <kio/http_slave_defaults.h>

#include "kcm/k2ch_config.h"

using namespace K2chConfig;

K2chProtocol::K2chProtocol(  const QCString &protocol, const QCString &pool,
	           const QCString &app )
  : HTTPProtocol( protocol, pool, app )
{
    if ( KGlobal::config()->readEntry( s_cacheDirEntry ).isEmpty() )
    {
	KGlobal::config()->writeEntry( s_cacheDirEntry, s_cacheDirDefault() );
    }
}

K2chProtocol::~K2chProtocol()
{
}

void K2chProtocol::get( const KURL& url )
{
    {
	QString tmp = filterURL( url ).path();
	if ( tmp.right(4) == ".dat" ) {
	    m_strMimeType = config()->readEntry(s_datMimeEntry, s_datMimeDefault);
	    mimeType( m_strMimeType );
	} else 
	if ( tmp.right(11) == "subject.txt" ) {
	    m_strMimeType = config()->readEntry(s_subjectMimeEntry, s_subjectMimeDefault);
	    mimeType( m_strMimeType );
	}
    }
    KURL newURL = filterURL( url );
    if ( newURL != url ) {
	redirection( newURL ); 
	//finished();
        HTTPProtocol::get( newURL );
	return;
    }
    HTTPProtocol::get( url );
}

void K2chProtocol::stat( const KURL& url )
{
    if ( ! checkRequestURL( url ) ) 
	return;

#if ( KDE_VERSION >= 310 )
    m_request.method = KIO::HTTP_HEAD;
#else
    m_request.method = HTTPProtocol::HTTP_HEAD;

#endif
    m_request.path = url.path();
    m_request.query = url.query();

    QString tmp = metaData("cache");
    if (!tmp.isEmpty())
	m_request.cache = KIO::parseCacheControl(tmp);
    else
	m_request.cache = DEFAULT_CACHE_CONTROL;

    m_request.passwd = url.pass();
    m_request.user = url.user();
    m_request.doProxy = m_bUseProxy;

    //bUseCache = true;

    if ( httpOpen() ) {
#if ( KDE_VERSION >= 310 )
	resetResponseSettings();
#endif
        if ( readHeader() )
	{
	    KIO::UDSEntry entry;
	    KIO::UDSAtom atom;

	    atom.m_uds = KIO::UDS_NAME;
	    atom.m_str = url.fileName();
	    entry.append( atom );

	    atom.m_uds = KIO::UDS_FILE_TYPE;
	    atom.m_long = S_IFREG; // a file
	    entry.append( atom );

	    atom.m_uds = KIO::UDS_ACCESS;
	    atom.m_long = S_IRUSR | S_IRGRP | S_IROTH; // readable by everybody
	    entry.append( atom );

#if ( KDE_VERSION >= 310 )
	    QString lastModified = m_request.lastModified;
#else
	    QString lastModified = m_lastModified;
#endif
	    if ( ! lastModified.isEmpty() )
	    {
		atom.m_uds = KIO::UDS_MODIFICATION_TIME; //a checksum of the 'Last-Modified' string.
		QCString array( lastModified.latin1() );
		atom.m_long = qChecksum( array.data(), array.size() );
		entry.append( atom );
		
		atom.m_uds = KIO::UDS_USER; // 'Last-Modified' string.
		atom.m_str = lastModified;
		entry.append( atom );
	    }
#if ( KDE_VERSION >= 310 )
	    if ( m_request.creationDate )
	    {
		atom.m_uds = KIO::UDS_ACCESS_TIME;
		atom.m_long = m_request.creationDate;
		entry.append( atom );
	    }
#endif
	    statEntry( entry );
	    finished();
	    return ;
	}
    } 

    HTTPProtocol::stat( url ); //HTTPProtocol do stat URL without accessing network.
    return ;
}

//// an 'url' contains "/test/read.cgi/" will be converted to the dat or so.
KURL K2chProtocol::filterURL( const KURL& _url ) 
{
    KURL  newURL = _url;
    if ( _url.path().contains("/test/read.cgi") ) {
	//convert read.cgi to DAT.
	QString tmp = _url.path().section("/test/read.cgi", 1);
	QString newPath = QString( "/%1/dat/%2.dat" )
	    			.arg( tmp.section('/', 1, 1) )
	    			.arg( tmp.section('/', 2, 2) );
	newURL.setPath( newPath );

	QString refBase = tmp.section('/', 3);
	if ( ! refBase.isEmpty() ) {
	    QString newRef =  refBase.section('-', 0, 0);
	    if( ! newRef.isEmpty() ) newURL.setRef( newRef );
	    else if ( refBase.at(0) == '-' ) newURL.setRef("1");
	    else newURL.setRef( refBase );
	}
    }
    return newURL;
}

extern "C" {
    int kdemain( int argc, char **argv );
}

int kdemain( int argc, char ** argv )
{
    KLocale::setMainCatalogue("kdelibs");
    KInstance instance( "kio_k2ch" );
    ( void ) KGlobal::locale();

    if ( argc != 4 )
    {
	fprintf(stderr, "Usage: kio_k2ch protocol domain-socket1 domain-socket2\n") ;
	exit( EXIT_FAILURE );
    }

    K2chProtocol slave( argv[1], argv[2], argv[3] );
    slave.dispatchLoop();

    return 0;
}
// vim:sw=4
