

#include <konq_faviconmgr.h>
#include <kiconloader.h>

#include <qcursor.h>
class QCursor;

#include <konq_sidebartree.h>
class QWidget;
class QListView;
class KListView;
class KonqSidebarTree;

#include <qpainter.h>
class QColorGroup;
class QPainter;

#include <konq_historymgr.h>
class KonqHistoryManager;

#include <qprogressdialog.h>
class QProgressDialog;

#include <qdict.h>
template<class type> class QDict;

#include <konq_popupmenu.h>
class KXMLGUIClient;
class KonqXMLGUIClient;
class QPopupMenu;
class KonqPopupMenu;

#include "k2chtree_item.h"


KonqSidebarK2chTreeItem::KonqSidebarK2chTreeItem( 
		KonqSidebarTreeItem *parentItem, 
		KonqSidebarTreeTopLevelItem *topLevelItem ) 
  : KonqSidebarTreeItem(  parentItem, topLevelItem )
  , m_parentItem( parentItem )
  , m_topLevelItem( topLevelItem )
  , m_method( K2ch::HTTP )
  , m_menu( listView() )
  , m_collection( listView(), "K2chTreeItemCollection" )
  , m_lastModified( 0 )
  , m_currentjob( 0 )
{
    KonqSidebarK2chTreeItem * k2ch_item = dynamic_cast<KonqSidebarK2chTreeItem *>( parentItem );
    if ( k2ch_item ) m_method = k2ch_item->m_method;
#if 0
    KStdAction::open( this, SLOT( open() ), &m_collection );

    m_menu.insertItem( QString( i18n("open with K2ch") ), this, SLOT( openWithK2ch() ) );
    m_menu.insertItem( QString( i18n("Search") ), this, SLOT(  ) );
    m_menu.insertItem( QString( i18n("Search") ), this, SLOT(  ) );
#endif
    KAction * act;
    act = KStdAction::open( this, SLOT( slotOpen() ), &m_collection );
    act->plug( &m_menu );
    act = new KAction( i18n("Create new window"), SmallIcon("window_new"), KShortcut(), 
	    this, SLOT( slotOpenNewWindow() ), &m_collection, "window_new" );
    act->plug( &m_menu );
    act = new KAction( i18n("Close tree."), SmallIcon(""), KShortcut(), 
	    this, SLOT( slotCloseTree() ), &m_collection, "close_tree" );
    act->plug( &m_menu );
}

void KonqSidebarK2chTreeItem::slotOpen()
{ emit tree()->openURLRequest( externalURL() ); }

void KonqSidebarK2chTreeItem::slotOpenNewWindow()
{ emit tree()->createNewWindow( externalURL() ); }

void KonqSidebarK2chTreeItem::slotCloseTree()
{ m_parentItem->setOpen(false); }

void KonqSidebarK2chTreeItem::itemSelected()
{
    printf("  KonqSidebarK2chTreeItem::itemSelected() url=%s( K2ch::K2CH? %d)\n", externalURL().url().latin1(), ( m_method == K2ch::K2CH ) );
    if ( ! firstChild() )
    {
	refreshChildList();
    }

    tree()->enableActions( true, true, true, false, false, true );
    printf("    size %d\n", sizeof( *this ) );
}

void KonqSidebarK2chTreeItem::rightButtonPressed()
{
    m_menu.exec( QCursor::pos() );
    
    //emit tree()->popupMenu( QCursor::pos(), externalURL(), QString() );
    
    //KParts::BrowserExtension * ext = KParts::BrowserExtension::childObject( tree()->part() );
    //printf("  KParts::BrowserExtension: %p %p\n", static_cast<void*>(ext), dynamic_cast<KonqSidebarK2chTreeModule*>(module()) );
    //module()->popupMenu( dynamic_cast<KonqSidebarK2chTreeModule*>(module())->xmlGUIClient(), QCursor::pos(), externalURL(), QString() );

#if 0
    KFileItem file( S_IFREG, S_IRUSR | S_IRGRP | S_IROTH, externalURL(), true );
    KFileItemList flist;
    flist.append( &file );
    KonqPopupMenu menu( KonqBookmarkManager::self(), flist, externalURL(), m_collection, 0 );
    menu.exec();
#endif
}

QDragObject * KonqSidebarK2chTreeItem::dragObject( QWidget * parent, bool )
{
    KBookmarkDrag * drag = KBookmarkDrag::newDrag( makeKBookmark(), parent );
    return drag;
}

KBookmark KonqSidebarK2chTreeItem::makeKBookmark()
{
    return KBookmark::standaloneBookmark( text(0), externalURL() );
}

void KonqSidebarK2chTreeItem::processStat( KIO::Job * job )
{
    printf("  KonqSidebarK2chBoardItem::processStat(KIO::Job *job = %p )\n", static_cast<void *>(job) );
    if ( ! job->error() ) {
	KIO::UDSEntry list = dynamic_cast<KIO::StatJob *>(job)->statResult();
	KIO::UDSEntry::iterator it = list.begin();
	for( ; !(it == list.end()); ++it )
	{
	    printf("    ");
	    switch ( (*it).m_uds ) {
		case KIO::UDS_MODIFICATION_TIME :
		    if ( (*it).m_long != m_lastModified )
		    {
			m_lastModified = (*it).m_long;
			emit urlModified();
		    }
		    break;
	    }
	}
    }
    m_currentjob = 0;
}




KonqSidebarK2chBaseItem::KonqSidebarK2chBaseItem( 
		KonqSidebarTreeItem *parentItem, 
		KonqSidebarTreeTopLevelItem *topLevelItem, 
		const K2ch::Base &base ) 
  : KonqSidebarK2chTreeItem(  parentItem, topLevelItem )
  , m_base( 0 )
{
    m_base = new K2ch::Base( base );
    if ( ! m_base ) return;

    setText( TITLE, m_base->name );
    setExpandable( false );
    QString icon = KonqFavIconMgr::iconForURL( m_base->topURL.url() );
    if ( ! icon.isEmpty() ) setPixmap( TITLE, SmallIcon( icon ) );
}

KonqSidebarK2chBaseItem::~KonqSidebarK2chBaseItem()
{
    if ( m_base ) delete m_base;
}

KURL KonqSidebarK2chBaseItem::externalURL( K2ch::Method method ) const
{
    if ( ! m_base ) return 0;
    KURL newURL;
    switch ( method ) {
	case K2ch::K2CH :
	    newURL = m_base->bbsmenu;
	    newURL.setProtocol( "k2ch" );
	    break;
	case K2ch::HTTP :
	default :
	    newURL = m_base->topURL;
	    break;
    }
    return newURL;
}

void KonqSidebarK2chBaseItem::refreshChildList(){
    setExpandable( false );
    QListViewItemIterator it( firstChild() );
    while( *it )
    {
	takeItem( *it );
	++it;
    }
    connect( m_base, SIGNAL( refreshCompleted( K2ch::Element* ) ), 
	     this, SLOT( refreshCompleted( K2ch::Element* ) ) );
    m_base->refreshChildList();
}

void KonqSidebarK2chBaseItem::refreshCompleted( K2ch::Element * )
{
    printf("  KonqSidebarK2chBaseItem::refreshCompleted()\n");
    if ( ! m_base ) return;

    QProgressDialog progress( tree() );
    progress.setLabel( new QLabel( QString( i18n("wait....") ), &progress ) );
    progress.show();

    QPtrListIterator<K2ch::Category> it_cate ( m_base->categoryList );
    progress.setTotalSteps( 1 + it_cate.count() );
    printf("    total step: %d\n", it_cate.count() );
    for ( it_cate.toLast() ; *it_cate; --it_cate )
    {
	KonqSidebarTreeItem * cate_item = 
	new KonqSidebarK2chCategoryItem( this, m_topLevelItem, **it_cate );

	QPtrListIterator<K2ch::Board> it_board( (*it_cate)->boardList );
	for ( it_board.toLast() ; *it_board; --it_board )
	{
	    //KonqSidebarTreeItem * board_item = 
	    new KonqSidebarK2chBoardItem( cate_item, m_topLevelItem, **it_board );
	}
	progress.setProgress( 1 + progress.progress() );
    }

    progress.setProgress( 1 + progress.progress() );
    setExpandable( true );
}




KonqSidebarK2chCategoryItem::KonqSidebarK2chCategoryItem( 
		KonqSidebarTreeItem *parentItem, 
		KonqSidebarTreeTopLevelItem *topLevelItem, 
		const K2ch::Category &category ) 
  : KonqSidebarK2chTreeItem(  parentItem, topLevelItem )
  , m_category( 0 )
{
    m_category = new K2ch::Category( category );

    if ( ! m_category ) return;
    setText( TITLE, m_category->name );
    setPixmap( TITLE, SmallIcon( "folder" ) );
}

KonqSidebarK2chCategoryItem::~KonqSidebarK2chCategoryItem()
{
    if ( m_category ) delete m_category;
}

void KonqSidebarK2chCategoryItem::setOpen( bool open )
{
    if ( open ) setPixmap( TITLE, SmallIcon( "folder_open" ) );
    else	 setPixmap( TITLE, SmallIcon( "folder" ) );

    KonqSidebarK2chTreeItem::setOpen( open );
}




KonqSidebarK2chBoardItem::KonqSidebarK2chBoardItem( 
		KonqSidebarTreeItem *parentItem, 
		KonqSidebarTreeTopLevelItem *topLevelItem, 
		const K2ch::Board &board ) 
  : KonqSidebarK2chTreeItem(  parentItem, topLevelItem )
  , m_board( 0 )
  , m_dict( 0 )
{
	m_board = new K2ch::Board( board );

    if ( ! m_board ) return ;
    setText( TITLE, m_board->name );
    setExpandable( false );
    QString icon = KonqFavIconMgr::iconForURL( m_board->url.url() );
    if ( ! icon.isEmpty() ) setPixmap( TITLE, SmallIcon( icon ) );
    connect( m_board, SIGNAL( refreshCompleted( K2ch::Element* ) ), 
	     this, SLOT( refreshCompleted( K2ch::Element* ) ) );
    connect( this, SIGNAL( urlModified() ),
	     this, SLOT( refreshChildList() ) );
}

KonqSidebarK2chBoardItem::~KonqSidebarK2chBoardItem()
{
    if ( m_board ) delete m_board;
    if ( m_dict ) {
	m_dict->setAutoDelete( false );
	delete m_dict;
    }
}

KURL KonqSidebarK2chBoardItem::externalURL( const K2ch::Method method ) const
{
    if ( ! m_board ) return 0;

    KURL newURL;
    switch ( method ) {
	case K2ch::K2CH :
	    newURL = m_board->subject_txt;
	    newURL.setProtocol( "k2ch" );
	    break;
	case K2ch::HTTP :
	default :
	    newURL = m_board->url;
	    break;
    }
    return newURL;
}

void KonqSidebarK2chBoardItem::refreshChildList()
{
    printf("  KonqSidebarK2chBoardItem::refreshChildList()\n");
    if ( ! m_currentjob ) {
	m_currentjob = reinterpret_cast<KIO::Job *>(1);
	setExpandable( false );
	if( ! m_board->refreshChildList() ) m_currentjob = 0;
    }

    QString icon = KonqFavIconMgr::iconForURL( m_board->url.url() );
    if ( ! icon.isEmpty() ) setPixmap( TITLE, SmallIcon( icon ) );
}

void KonqSidebarK2chBoardItem::refreshCompleted( K2ch::Element* )
{
    printf("  KonqSidebarK2chBoardItem::refreshCompleted()\n");
    //setOpen( false );

    QProgressDialog progress( tree() );
    progress.setLabel( new QLabel( QString( i18n("Wait.") ), &progress ) );
    progress.show();

    //QDict<KonqSidebarK2chThreadItem> * m_dict = 0;
    if ( ! m_dict ) {
	// min 32 , max 32  //live
	// min 300, max 300 //news
	// min 500, max 600 //
	int prime[] = { 31, 37, 41, 43, 307, 311, 313, 317,
	      503, 509, 521, 523, 541, 547, 557, 563, 569, 571, 577, 587, 593, 599,
	      601, 607, 613, 617,
	      1031 }; // prime numbers.
	int thread_count = 5 + m_board->threadList.count();
	int * tmp = prime;
	for( ; *tmp < thread_count || *tmp < 1031; ++tmp );
	m_dict = new QDict<KonqSidebarK2chThreadItem>( *tmp );
	if ( ! m_dict ) return;
    }
    progress.setTotalSteps( 1 + childCount() + m_board->threadList.count() );
    int step = 0;

    { //remove all items.
	KonqSidebarK2chThreadItem * item;
	while( ( item = dynamic_cast<KonqSidebarK2chThreadItem *>(firstChild()) ) )
	{
	    takeItem( item );
	    if ( (++step)%10 == 0 ) progress.setProgress( step );
	}
    }

    { //insert items.
	KonqSidebarK2chThreadItem * item;
	QPtrListIterator<K2ch::Thread> it_thread( m_board->threadList );
	for ( it_thread.toFirst(); ! it_thread.atLast(); ++it_thread )
	{
	    if ( ( item = (*m_dict)[ (*it_thread)->name ] ) )
	    {
		insertItem( item );
		item->setThread( **it_thread );
	    } else {
		item = new KonqSidebarK2chThreadItem( this, m_topLevelItem, **it_thread );
		m_dict->insert( item->text( NAME_Sort ), item );
		//Memo: QDict use hash internally.
	    }
	    //progress.setProgress( 1 + progress.progress() );
	    if ( ( (++step)%10 ) == 0 ) progress.setProgress( step );
	}
    }

    sortChildItems( ASIS_Sort, true );
    progress.setProgress( ++step );
    setExpandable( true );
    //setOpen( true );
    m_currentjob = 0;
}

void KonqSidebarK2chBoardItem::itemSelected()
{
    printf("  KonqSidebarK2chBoardItem::itemSelected()\n");
    printf("    size %d\n", sizeof( *this ) );
    KonqSidebarK2chTreeItem::itemSelected();
    checkUpdate();
}

void KonqSidebarK2chBoardItem::checkUpdate()
{
    if ( ! m_board ) return ;
    printf("\n\n   KonqSidebarK2chBoardItem::checkUpdate()\n");
    if ( ! m_currentjob )
    {
	KIO::Job * job = KIO::stat( m_board->subject_txt );
	connect( job, SIGNAL( result(KIO::Job *) ),
	     this, SLOT( processStat(KIO::Job *) ) );
    }
}




KonqSidebarK2chThreadItem::KonqSidebarK2chThreadItem( 
		KonqSidebarTreeItem *parentItem, 
		KonqSidebarTreeTopLevelItem *topLevelItem, 
		const K2ch::Thread & thread ) 
  : KonqSidebarK2chTreeItem(  parentItem, topLevelItem )
  , m_thread( 0 )
{
    m_thread = new K2ch::Thread( thread );
    initText();
    setExpandable( false );
    //QString icon = KonqFavIconMgr::iconForURL( m_thread->url.url() );
    //if ( ! icon.isEmpty() ) setPixmap( TITLE, SmallIcon( icon ) );
}

KonqSidebarK2chThreadItem::~KonqSidebarK2chThreadItem()
{
    if ( m_thread ) delete m_thread;
}

void KonqSidebarK2chThreadItem::setThread( const K2ch::Thread &_in )
{
    *m_thread = _in;
    initText();
}

void KonqSidebarK2chThreadItem::initText()
{
    //setText( TITLE, m_thread->name );
    setText( TITLE, QString("%1: %2 (%3, new:%4)").arg( m_thread->sortkey,3 ).arg( m_thread->name ).arg( m_thread->rescount ).arg( m_thread->rescount - m_thread->prev_rescount ) );
    //setText( TITLE, QString(" %2 (%3)").arg( m_thread->name ).arg( m_thread->rescount  ) );
    setText( ASIS_Sort, QString("%1").arg( m_thread->sortkey, 4 ) );
    setText( NAME_Sort, m_thread->name );
}

KURL KonqSidebarK2chThreadItem::externalURL() const
{
    switch ( m_method )
    {
	case K2ch::K2CH :
	default:
	    return externalURL( K2ch::K2CH );
	    return 0;
	case K2ch::HTTP :
	    return externalURL( K2ch::HTTP );
    }
}

KURL KonqSidebarK2chThreadItem::externalURL( K2ch::Method method ) const
{
    KURL newURL;
    switch ( method ) {
	case K2ch::K2CH :
	    newURL = m_thread->dat;
	    //newURL.setRef( QString::number( m_thread->prev_rescount  ) );
	    newURL.setProtocol( "k2ch" );
	    break;
	case K2ch::HTTP :
	default :
	    newURL = m_thread->url.url(-1).append("/%1-").arg( m_thread->rescount - 50 );
	    break;
    }
    return newURL;
}

void KonqSidebarK2chThreadItem::itemSelected()
{
    m_thread->prev_rescount = m_thread->rescount;
    initText();
    KonqSidebarK2chTreeItem::itemSelected();
    //KitaThreadView * wgt = new KitaThreadView( 0 );
    //wgt->showThread( m_thread->dat, m_thread->board->url );
    //wgt->show();
}

void KonqSidebarK2chThreadItem::paintCell( QPainter *p, const QColorGroup & cg, int column, int width, int)
{

    {
	QColor bgcolor;
	QColor txtcolor;
	if( isSelected() ) 
	{
	    bgcolor = cg.highlight();
	    txtcolor = cg.highlightedText();
	} else {
	    KonqHistoryList list( KonqHistoryManager::kself()->entries() );
	    KURL k2ch = externalURL( K2ch::K2CH );
	    KURL http = externalURL( K2ch::HTTP );
	    k2ch.setRef(0);
	    http.setRef(0);
	    if ( list.findEntry( k2ch )
	      || list.findEntry( http ) ) {
		txtcolor = cg.linkVisited();
	    } else {
		txtcolor = cg.text();
	    }

	    if ( 0 ){ //will be configurable?
	        bgcolor = cg.base();
	    } else {
		bool b_isLighter = true;
	        if( (m_thread->sortkey)%2 ) 
	        {
		    bgcolor = b_isLighter ? cg.midlight() : cg.midlight();
	        } else {
		    bgcolor = b_isLighter ? cg.button() : cg.mid();
		}
	    }
	}

	p->fillRect( 0, 0, width, height(), bgcolor );
	p->setPen( txtcolor );
        p->drawText( 0, height()-4, text(column) );
	if ( m_thread->rescount != m_thread->prev_rescount )
	{
	    p->drawPixmap( 0, 0, SmallIcon( "ok" ) );
	}
    }
}

//#include "k2chtree_item.moc.cpp"
// vim:sw=4
