/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@wakaba.jp                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef _KITATHREADVIEW_H_
#define _KITATHREADVIEW_H_

#include <kurl.h>
#include <qwidget.h>
#include <qcstring.h>

#include "kitathreadviewbase.h"

class KitaModel;
class KURL;
class KHTMLPart;

namespace KIO {
  class Job;
}

/**
 * 
 * Hideki Ikemoto
 **/
class KitaThreadView : public KitaThreadViewBase
{
  Q_OBJECT

public:
  KitaThreadView(QWidget *parent, const char *name=0);
  ~KitaThreadView();
  void setModel(KitaModel* _m);
  void showThread(KURL _datURL, KURL _boardURL);
private: // Private attributes
  KitaModel* model;
  KHTMLPart* threadPart;
  QCString m_threadData;
  KURL m_datURL;
  KURL m_boardURL;
  QCString m_writeResult;
  int serverTime;
public slots:
  void slotReceiveThreadData(KIO::Job* job, const QByteArray& data);
  void slotThreadResult(KIO::Job* job);
  void slotWriteButtonClicked();
  void slotReceiveWriteResult(KIO::Job* job,  const QByteArray & data);
  void slotWriteResult(KIO::Job* job);
  void slotCanceled(KIO::Job* job);
};

#endif
