/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@wakaba.jp                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <qfile.h>
#include <qtextstream.h>
#include <qtextcodec.h>
#include <qlayout.h>
#include <qtoolbutton.h>
#include "qcp932codec.h"
#include <qsjiscodec.h>
#include <qlabel.h>

#include <time.h>

#include <ktextbrowser.h>
#include <kurl.h>
#include <kio/netaccess.h>
#include <kio/slaveconfig.h>
#include <khtml_part.h>
#include <khtmlview.h>
#include <kio/jobclasses.h>
#include <kio/scheduler.h>

#include "kitathreadview.h"
#include "kitawritedialog.h"

KitaThreadView::KitaThreadView(QWidget *parent, const char *name)
    : KitaThreadViewBase(parent, name)
{
  threadPart = new KHTMLPart(threadFrame);
  QHBoxLayout* aLayout = new QHBoxLayout(threadFrame);
  threadPart->setStandardFont("Gothic [Mona]");
  threadPart->setZoomFactor(120); // 12px;
  aLayout->addWidget(threadPart->view());

  connect(writeButton, SIGNAL(clicked()), SLOT(slotWriteButtonClicked()));
}

KitaThreadView::~KitaThreadView() {}

void KitaThreadView::setModel(KitaModel* _m)
{
  model = _m;
}


void KitaThreadView::showThread(KURL _datURL, KURL _boardURL)
{
  KIO::SlaveConfig::self()->setConfigData("http", _datURL.host() ,
                                          "UserAgent", "Monazilla/1.00 (test)");
  m_datURL = _datURL;
  m_boardURL = _boardURL;

  KIO::TransferJob* job = KIO::get(m_datURL, true, true);

  connect(job, SIGNAL(data(KIO::Job*, const QByteArray&)),
          SLOT(slotReceiveThreadData(KIO::Job*, const QByteArray&)));
  connect(job, SIGNAL(result(KIO::Job*)), SLOT(slotThreadResult(KIO::Job*)));

  // use 'HTTP-Headers' metadata.
  job->addMetaData("PropagateHttpHeader", "true");
}

void KitaThreadView::slotReceiveThreadData(KIO::Job* job, const QByteArray& data)
{
  QCString cstr(data.data(), data.size()+1);
  m_threadData.append(cstr);
}

void KitaThreadView::slotThreadResult(KIO::Job* job)
{
  qDebug("slotThreadResult()");

  if(job->error()) {
    job->showErrorDialog();
    return;
  }

  QCp932Codec codec;
  QTextStream stream(m_threadData, IO_ReadOnly);
  stream.setCodec(&codec);
  QString line;
  QString text;
  int num = 1;

  // parse HTTP headers
  QStringList headerList = QStringList::split("\n", job->queryMetaData("HTTP-Headers"));
  QRegExp regexp("Date: (...), (..) (...) (....) (..:..:..) .*");
  QString dateStr = headerList.grep(regexp)[0];
  if(regexp.search(dateStr) == -1) {
    // invalid date format
    qDebug("slotThreadResult() invalid Date:");
    return;
  }

  // I hate this format ;p
  QString usLocalDateStr = regexp.cap(1) + " " + regexp.cap(3) + " " +
                           regexp.cap(2) + " " + regexp.cap(5) + " " + regexp.cap(4);

  // 1970/01/01 00:00:00 GMT
  QDateTime zeroTime(QDate(1970, 1, 1), QTime(0, 0));

  serverTime = zeroTime.secsTo(QDateTime::fromString(usLocalDateStr));

  while(!stream.atEnd()) {
    line = stream.readLine();
    QStringList list = QStringList::split("<>", line, true);

    if(list.size() != 5) {
      // probably eof
      break;
    }
    QString name = list[0];
    QString address = list[1];
    QString dateId = list[2];
    QString body = list[3];
    QString subject = list[4];

    if(num == 1) {
      subjectLabel->setText(subject);
    }
    text += "<dl><dt>";
    text += QString::number(num);
    text += " ";
    if(address != "") {
      text += "<a href=\"mailto:" + address + "\">" + name + "</a>";
    } else {
      text += name;
    }
    text += " ";
    text += dateId;
    text += "</dt><dd>";
    text += body;
    text += "<br><br></dd></dl>";

    num++;
  }
  threadPart->begin();
  threadPart->write(text);
  threadPart->end();

  m_threadData.truncate(0);

  qDebug("~slotThreadResult()");
}

void KitaThreadView::slotWriteButtonClicked()
{
  qDebug("slotWriteButtonClicked()");

  KitaWriteDialog dialog;

  qDebug("slotWriteButtonClicked() dialog created.");

  QSjisCodec cp932Codec;
  int cp932MIB = cp932Codec.mibEnum();
  KURL bbscgiURL = KURL(m_boardURL, "../test/bbs.cgi");
  QString bbsName = m_boardURL.fileName();
  QString datName = QStringList::split(".", m_datURL.fileName())[0];

  qDebug("slotWriteButtonClicked() before dialog.exec()");
  if(dialog.exec() != QDialog::Accepted) {
    return;
  }

  QString postStr;
  QTextStream stream(&postStr, IO_WriteOnly);
  QString name = KURL::encode_string(dialog.name(), cp932MIB);
  QString mail = KURL::encode_string(dialog.mail(), cp932MIB);
  QString body = KURL::encode_string(dialog.body(), cp932MIB);

  stream << "submit=%91%53%90%d3%94%43%82%f0%95%89%82%a4%82%b1%82%c6"; // zennsekininnwooukoto
  stream << "%82%f0%8f%b3%91%f8%82%b5%82%c4%8f%91%82%ab%8d%9e%82%de&"; // wosyoudakusitekakikomu
  stream << "subject=&";
  stream << "FROM=" << name << "&";
  stream << "mail=" << mail << "&";
  stream << "MESSAGE=" << body << "&";
  stream << "bbs=" << bbsName << "&";
  stream << "key=" << datName << "&";
  stream << "time=" << serverTime;

  KIO::TransferJob* job = KIO::http_post(bbscgiURL, postStr.utf8(), true);

  // see kdelibs/kioslave/http/http.cc:2216
  job->addMetaData("content-type", "Content-type: application/x-www-form-urlencoded");

  job->addMetaData("referrer", KURL(m_boardURL,"./index2.html").prettyURL());

  connect(job, SIGNAL(data(KIO::Job*, const QByteArray&)),
          SLOT(slotReceiveWriteResult(KIO::Job*, const QByteArray&)));
  connect(job, SIGNAL(result(KIO::Job*)), SLOT(slotWriteResult(KIO::Job*)));

  qDebug("~slotWriteButtonClicked()");
}

void KitaThreadView::slotReceiveWriteResult(KIO :: Job * job,  const QByteArray & data)
{
  qDebug("slotReceivem_writeResult()");

  QCString cstr(data.data(), data.size()+1);
  m_writeResult += cstr;

  qDebug("~slotReceivem_writeResult()");
}

void KitaThreadView::slotWriteResult(KIO::Job* job)
{
  qDebug("slotm_writeResult()");

  if(job->error()) {
    job->showErrorDialog();
  } else {
    QSjisCodec codec;
    QTextStream stream(m_writeResult, IO_ReadOnly);
    stream.setCodec(&codec);

    qDebug("#%s#", (const char *)stream.read().local8Bit());
    m_writeResult.truncate(0);
  }
  qDebug("~slotm_writeResult()");
}

void KitaThreadView::slotCanceled(KIO::Job* job)
{
  qDebug("slotCanceled()");
  qDebug("~slotCanceled()");
}
