/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@wakaba.jp                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef _KITASUBJECTVIEW_H_
#define _KITASUBJECTVIEW_H_

#include <qwidget.h>
#include <kurl.h>
#include "kitasubjectviewbase.h"

class KitaModel;
class Kita;

/**
 * 
 * Hideki Ikemoto
 **/
class KitaSubjectView : public KitaSubjectViewBase
{
  Q_OBJECT

public:
  KitaSubjectView(QWidget *parent, Kita* _mainWindow, const char *name=0);
  ~KitaSubjectView();
  void setModel(KitaModel* _m);
  void loadBoard(KURL url);
public slots:
  void reloadSubject();
  void loadThread(QListViewItem* item);
private: // Private attributes
  KitaModel* model;
  Kita* mainWindow;
  KURL boardURL;
};

#endif
