/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@wakaba.jp                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

// include files for Qt
#include <qtoolbutton.h>
#include <qtextbrowser.h>
#include <qtextcodec.h>
#include <qregexp.h>
#include <qfile.h>

// kdelibs/kio
#include <kio/slaveconfig.h>
#include <kio/netaccess.h>

// include files for KDE
#include <kfilterdev.h>
#include <klistview.h>
 
#include "kitasubjectview.h"
#include "kita.h"

KitaSubjectView::KitaSubjectView(QWidget *parent, Kita* _mainWindow, const char *name)
  : KitaSubjectViewBase(parent, name)
{
  subjectList->addColumn("No");
  subjectList->addColumn("Title");
  subjectList->addColumn("ResNum");
  subjectList->addColumn("Dat");
  mainWindow = _mainWindow;
  connect(subjectList, SIGNAL(clicked(QListViewItem*)), SLOT(loadThread(QListViewItem*)));
}


KitaSubjectView::~KitaSubjectView()
{
}

void KitaSubjectView::reloadSubject()
{
}

void KitaSubjectView::loadThread(QListViewItem* item)
{
  QString datName = item->text(3);
  QString tmpFile;
  KURL url = boardURL;
  url.addPath("/dat/" + datName);
  mainWindow->showThread(url, boardURL);
}

void KitaSubjectView::setModel(KitaModel* _m)
{
  model = _m;
}

void KitaSubjectView::loadBoard(KURL url)
{
  boardURL = url;
  KIO::SlaveConfig::self()->setConfigData("http", url.host() , "UserAgent", "Monazilla/1.00 (test)");
  
  QString tmpFile;
  url.addPath("subject.txt");
  if(KIO::NetAccess::download(url, tmpFile)) {
    QIODevice* tmpDevice = KFilterDev::deviceForFile(tmpFile, "application/x-gzip");
    tmpDevice->open(IO_ReadOnly);
    
    QTextStream stream(tmpDevice);
    stream.setCodec(QTextCodec::codecForName("Shift_JIS"));
    
    // clear list
    subjectList->clear();
    
    // parse subject.txt(only one format...)    
    QRegExp regexp("(\\d+\\.dat)<>(.*)\\((\\d+)\\)");
    QString line;
    int row=0;
    
    while((line = stream.readLine()) != QString::null) {
      int pos = regexp.search(line);
      if(pos != -1) {
        QString fname = regexp.cap(1);
        QString subject = regexp.cap(2);
        QString num = regexp.cap(3);
  
        new QListViewItem(subjectList, QString("%1").arg(row, 4), subject, num, fname);
        row++;
      }
    }
        
    KIO::NetAccess::removeTempFile(tmpFile); 
  }
}
