/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@wakaba.jp                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <kio/netaccess.h>

#include <qfile.h>
#include <qtextcodec.h>
#include <qstringlist.h>
#include <qregexp.h>
#include <klistview.h>

#include "kitaboardview.h"
#include "kita.h"


KitaBoardView::KitaBoardView(QWidget *parent, Kita* _m, const char *name)
    : KitaBoardViewBase(parent, name)
{
  boardList->setSorting(-1);
  boardList->addColumn("name");
  mainWindow = _m;
  connect(boardList, SIGNAL(executed(QListViewItem*)), SLOT(loadBoard(QListViewItem*)));
}


KitaBoardView::~KitaBoardView()
{}

void KitaBoardView::setModel(KitaModel* _m)
{
  model = _m;
}

void KitaBoardView::loadBoardList()
{
  QString tmpFile;
  QString url = "http://www.ff.iij4u.or.jp/~ch2/bbsmenu.html";
  if(KIO::NetAccess::download(url, tmpFile))
  {
    QFile file(tmpFile);
    QTextStream stream(&file);
    stream.setCodec(QTextCodec::codecForName("Shift_JIS"));

    if(file.open(IO_ReadOnly))
    {
      QString html = stream.read();
      //      BoardList board(html);

      /* boardList*/
      QStringList lines = QStringList::split("\n", html);
      QStringList::iterator it;

      QRegExp category_r("<BR><BR><B>(.*)</B><BR>");
      QRegExp board_r("<A HREF=(.*)>(.*)</A>");

      KListViewItem* current_category = 0;
      KListViewItem* current_board = 0;
      for(it = lines.begin(); it != lines.end(); ++it)
      {
        if(category_r.search(*it) != -1)
        {
          QString category = category_r.cap(1);
//          QString board_url = category_r.cap(2);
//          QString board_title = category_r.cap(3);

          current_category = new KListViewItem(boardList, current_category, category);
//          current_board = new KListViewItem(current_category, board_title, board_url);
        }
        else if(board_r.search(*it) != -1)
        {
          QString board_url = board_r.cap(1);
          QString board_title = board_r.cap(2);

          if(current_category != 0)
          {
            new KListViewItem(current_category, current_board, board_title, board_url);
          }
        }
      }
    }
  }
}

void KitaBoardView::loadBoard(QListViewItem* item)
{
  KURL url = item->text(1);
  mainWindow->loadBoard(url);
}
