/*
 * Copyright (C) 2001 Hideki Ikemoto <ikemo@wakaba.jp>
 */

#ifndef _KITA_H_
#define _KITA_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapplication.h>
#include <kdockwidget.h>

#include "kitaview.h"

class KPrinter;
class KToggleAction;
class KURL;
class KitaThreadView;
class KitaBoardView;
class KitaSubjectView;
class KitaModel;

/**
 * This class serves as the main window for Kita.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author $AUTHOR <$EMAIL>
 * @version $APP_VERSION
 */
class Kita : public KDockMainWindow
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    Kita();

    /**
     * Default Destructor
     */
    virtual ~Kita();

    /**
     * Use this method to load whatever file/URL you have
     */
    void load(const KURL& url);
  void showThread(KURL _datURL, KURL _boardURL);

protected:
    /**
     * Overridden virtuals for Qt drag 'n drop (XDND)
     */
    virtual void dragEnterEvent(QDragEnterEvent *event);
    virtual void dropEvent(QDropEvent *event);

protected:
    /**
     * This function is called when it is time for the app to save its
     * properties for session management purposes.
     */
    void saveProperties(KConfig *);

    /**
     * This function is called when this app is restored.  The KConfig
     * object points to the session management config file that was saved
     * with @ref saveProperties
     */
    void readProperties(KConfig *);


private slots:
    void fileNew();
    void fileOpen();
    void fileSave();
    void fileSaveAs();
    void filePrint();
    void optionsShowToolbar();
    void optionsShowStatusbar();
    void optionsConfigureKeys();
    void optionsConfigureToolbars();
    void optionsPreferences();
    void newToolbarConfig();

    void changeStatusbar(const QString& text);
    void changeCaption(const QString& text);

private:
    void setupAccel();
    void setupActions();
    void setupView();
    void setupModel();

private:
    KitaThreadView *m_threadview;
    KitaModel *m_model;
    KitaBoardView* m_boardView;
    KitaSubjectView* m_subjectView;

    KPrinter   *m_printer;
    KToggleAction *m_toolbarAction;
    KToggleAction *m_statusbarAction;
public slots:
  void loadBoard(KURL url);
};

#endif // _KITA_H_
