/***************************************************************************
*   Copyright (C) 2004 by Kita Developers                                 *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KITASUBJECTTABWIDGET_H
#define KITASUBJECTTABWIDGET_H

#include "kitaui/tabwidgetbase.h"

#include "favoritelistview.h"
#include "boardview.h"

/**
@author Hideki Ikemoto
*/
class KitaSubjectTabWidget : public KitaTabWidgetBase
{
    Q_OBJECT

public:
    KitaSubjectTabWidget( QWidget* parent = 0, const char* name = 0, WFlags f = 0 );
    ~KitaSubjectTabWidget();

public slots:
    void loadBoard( const KURL&, bool withNewTab = false );

private:
    KitaBoardView* createView( QString label );
    KitaBoardView* findView( const KURL& boardURL );
    KitaBoardView* isSubjectView( QWidget* w );

protected:
    virtual void deleteWidget( QWidget* w );


    /* tab actions */

private:
    void setupActions();

public slots:
    void slotReloadButton();
    void slotFocusSearchCombo();
    void slotNewThread();
    void slotShowOldLogs( int idx = -1 );
    void slotShowTitleImg( int idx = -1 );
};

/*--------------------------------------------------*/

class SubjectTabBar : public KitaTabBarBase
{
    Q_OBJECT

public:
    SubjectTabBar( QWidget* parent = 0, const char* name = 0 );
    ~SubjectTabBar();

private:
    virtual void showPopupMenu( int idx, QPoint global );

};


/*--------------------------------------------------*/


class KitaSubjectDock : public KitaDockWidgetBase
{

    Q_OBJECT
    KitaSubjectTabWidget* m_subjectTab;
public:
    KitaSubjectDock( KDockManager* dockManager,
                     const char* name,
                     const QPixmap &pixmap,
                     QWidget* parent = 0L,
                     const QString& strCaption = QString::null,
                     const QString& strTabPageLabel = QString::fromLatin1( " " ),
                     WFlags f = 0 );
    ~KitaSubjectDock();

    KitaSubjectTabWidget* setup();

public slots:
    void slotLoadBoard( const KURL& boardURL, bool withNewTab );
};



#endif
