/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef _KITATHREADVIEW_H_
#define _KITATHREADVIEW_H_

#include "threadviewbase.h"

#include <kparts/browserextension.h>
#include <dom/html_base.h>

#include <ktextbrowser.h>

class KURL;
class KitaHTMLPart;

#include <qvaluestack.h> // for gcc-2.9x
template <class T> class QValueStack;

namespace Kita
{
    class KitaSubjectLabel;
}

/* mode , m_viewmode uses them. */
enum {
    VIEWMODE_MAINVIEW,
    VIEWMODE_KITANAVI
};

namespace KIO
{
    class Job;
}

/**
 *
 * @author Hideki Ikemoto <ikemo@users.sourceforge.jp>
 **/

class KitaThreadView : public KitaThreadViewBase
{
    Q_OBJECT

public:
    KitaThreadView( QWidget* parent, const char* name = 0 );
    ~KitaThreadView();
    const QString threadName() const;
    const KURL threadURL() const;
    const KURL datURL() const;
    const QString selectedText() const;

    void setup( const KURL& datURL, int mode );
    void showStatusBar( QString info );
    int getViewMode() { return m_viewmode; }

    /* for preview and KitaNavi */
    void domAppendData( QString& str, int bufnum, int num );
    void domDeleteRes( int bufnum );
    void domAppendBelt( QString idstr );
    void domSetInnerHTML( const QString& html );
    void domApplyChange( QString lbstr, QString hstr, QString fstr, QString anchor, QString cmbstr );

public slots:
    virtual void setFocus();

    void subjectlinkClicked( const QString& URL );
    void subjectlinkMClicked( const QString &URL );
    void showThread( const KURL& datURL, int num );
    void setFont( const QFont& font );
    void slotReloadButton( int jumpNum = 0 );
    void slotStopLoading();
    void focusSearchCombo();
    void slotDeleteButtonClicked();
    void slotSearchNext();
    void slotSearchPrev();
    void slotGobackAnchor();
    void slotGotoHeader();
    void slotGotoFooter();

protected slots:
    void slotDOMNodeActivated( const DOM::Node& node );
    void slotPopupMenu( KXMLGUIClient*, const QPoint&, const KURL&, const QString&, mode_t );

private:
    int m_serverTime;
    KURL m_datURL;
    KitaHTMLPart* m_threadPart;
    Kita::KitaSubjectLabel* subjectLabel;

    bool m_revsearch;
    int m_viewmode;
    int m_rescode;

    void appendRes( int startnum, int endnum );

    void insertSearchCombo();
    void setSubjectLabel( const QString& boardName, const QString& threadName, const QString boardURL );
    QStringList parseSearchQuery( const QString& input ) const;
    void updateButton();

private slots:
    void slotSearchButton();
    void slotBookmarkButtonClicked( bool on );
    void slotWriteButtonClicked( QString resstr = QString::null );
    void slotComboActivated( int index );
    void slotUpdateInfo();
    void slotSearchPrivate( bool rev );
    void slotCloseButton();

signals:
    void datURLRedirected( const KURL& newDatURL );
    void postResponse( const QString& response, const KURL& bbscgi = KURL() );
    //re-impl signals of KParts::Browserextension of KHTMLPart
    void openURLRequest( const KURL& url, const KParts::URLArgs& args = KParts::URLArgs() );
    void createNewWindow( const KURL& url, const KParts::URLArgs& args = KParts::URLArgs() );
    void setLocationBarURL( const QString& url );
    void enableAction( const char* name, bool enabled );
    void popupMenu( KXMLGUIClient*, const QPoint&, const KURL&, const QString&, mode_t );
    void updateSubjectTab( const KURL& datURL );
    void updateThreadTab( const KURL& datURL );
    void setMainURLLine( const KURL& url );
    void setMainCaption( const QString& captionStr );
    void setMainStatusbar( const QString& statusStr );
    void bookmarked( const QString& datURL, bool on );
    void showThreadCompleted(); /* to KitaThreadPart */
    void closeThreadTab( const KURL& url );
    void closeCurrentTab(); /* to KitaThreadTabWidget */
    void openURLRequestExt( const KURL& url, const KParts::URLArgs& args = KParts::URLArgs(),
                            QString mimetype = QString::null,
                            int usr1 = 0, int usr2 = 0,
                            const KURL& usrUrl1 = KURL(),
                            const KURL& usrUrl2 = KURL(),
                            const QString& usrStr1 = QString::null,
                            const QString& usrStr2 = QString::null );

    /* kita navi */
    void showKitaNaviByWord( const KURL& , QString );
    void showWriteView( const KURL& , const QString& );
    void createNewThread( const KURL& , const QString&, const QString& );
    void activateThreadView( const KURL& );
};

namespace Kita
{
    // reimplement KActiveLabel based KTextBrowser
    class KitaSubjectLabel : public KTextBrowser
    {
        Q_OBJECT

    public:
        KitaSubjectLabel( QWidget *parent, const char * name = 0 );

        QSize minimumSizeHint() const;
        QSize sizeHint() const;

    private slots:
        void paletteChanged();
        void popupOpenAsNewTab();
        void popupCopyToClipboard();
        void popupFavorites();

    protected:
        virtual QPopupMenu * createPopupMenu ( const QPoint & pos );
        virtual void contentsMousePressEvent ( QMouseEvent * e );
        virtual void contentsMouseReleaseEvent ( QMouseEvent * e );

    signals:
        void urlMClick( const QString& url );

    private:
        QString m_popupURL;
    };

}

#endif
