/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KITACONFIG_H
#define KITACONFIG_H

#include <qfont.h>

#include <kcompletion.h>

class KConfig;

/**
@author Hideki Ikemoto
*/
class KitaConfig
{
public:
    enum SortOrder {
        Order_Mark,
        Order_ID
    };

private:
    static KitaConfig* instance;
    QColor m_threadColor;
    QColor m_threadBackgroundColor;
    QColor m_popupColor;
    QColor m_popupBackgroundColor;
    QFont m_listFont;
    QFont m_threadFont;
    QFont m_popupFont;
    QString m_boardListURL;
    KCompletion m_nameCompletion;
    bool m_useStyleSheet;
    QString m_styleSheetText;
    QStringList m_asciiArtList;
    bool m_showMailAddress;
    QStringList m_aboneNameList;
    QStringList m_aboneIDList;
    QStringList m_aboneWordList;
    bool m_aboneChain;
    int m_MarkTime;
    bool m_alwaysUseTab;
    SortOrder m_sortOrder;
    bool m_showAA;
    int m_showNum;
    bool m_usePart;
    bool m_useImageViewer;
    bool m_useImagePopup;
    bool m_useMosaic;
    bool m_useKitaNavi;
    QStringList m_partMimeList;
    QString m_userID;
    QString m_password;
    bool m_autoLogin;
    bool m_checkResponsed;
    bool m_copyOnClick;

    KitaConfig();
    virtual ~KitaConfig();

    static QString encryptStr( const QString& str );
    static QString decryptStr( const QString& str );
public:
    static void writeConfig( KConfig* config );
    static void readConfig( KConfig* config );

    static KitaConfig* getInstance();
    static QFont& listFont() { return getInstance() ->m_listFont; }
    static void setListFont( QFont font ) { getInstance() ->m_listFont = font; }
    static QFont defaultListFont() { return QFont(); }

    static QFont& threadFont() { return getInstance() ->m_threadFont; }
    static void setThreadFont( QFont font ) { getInstance() ->m_threadFont = font; }
    static QFont defaultThreadFont() { return QFont(); }

    static QFont& popupFont() { return getInstance() ->m_popupFont; }
    static void setPopupFont( QFont font ) { getInstance() ->m_popupFont = font; }
    static QFont defaultPopupFont() { return QFont(); }

    static void setBoardListURL( QString url ) { getInstance() ->m_boardListURL = url; }
    static QString& boardListURL() { return getInstance() ->m_boardListURL; }
    static KCompletion* nameCompletion() { return & ( getInstance() ->m_nameCompletion ); }
    static void addNameCompletionItem( QString& item ) { getInstance() ->m_nameCompletion.addItem( item ); }
    static void setNameCompletionItems( QStringList list ) { getInstance() ->m_nameCompletion.setItems( list ); }

    static QColor& threadColor() { return getInstance() ->m_threadColor; }
    static void setThreadColor( QColor color ) { getInstance() ->m_threadColor = color; }
    static QColor defaultThreadColor() { return QColor( "black" ); }

    static QColor& threadBackgroundColor() { return getInstance() ->m_threadBackgroundColor; }
    static void setThreadBackgroundColor( QColor color ) { getInstance() ->m_threadBackgroundColor = color; }
    static QColor defaultThreadBackgroundColor() { return QColor( "white" ); }

    static QColor& popupColor() { return getInstance() ->m_popupColor; }
    static void setPopupColor( QColor color ) { getInstance() ->m_popupColor = color; }
    static QColor defaultPopupColor() { return QColor( "black" ); }

    static QColor& popupBackgroundColor() { return getInstance() ->m_popupBackgroundColor; }
    static void setPopupBackgroundColor( QColor color ) { getInstance() ->m_popupBackgroundColor = color; }
    static QColor defaultPopupBackgroundColor() { return QColor( "yellow" ); }

    static bool useStyleSheet() { return getInstance() ->m_useStyleSheet; }
    static void setUseStyleSheet( bool value ) { getInstance() ->m_useStyleSheet = value; }
    static bool defaultUseStyleSheet() { return false; }

    static QString& styleSheetText() { return getInstance() ->m_styleSheetText; }
    static void setStyleSheetText( QString text ) { getInstance() ->m_styleSheetText = text; }
    static QString defaultStyleSheetText();

    static QStringList& asciiArtList() { return getInstance() ->m_asciiArtList; }
    static void setAsciiArtList( QStringList list ) { getInstance() ->m_asciiArtList = list; }
    static QStringList defaultAsciiArtList() { return QStringList(); }

    static bool showMailAddress() { return getInstance() ->m_showMailAddress; }
    static void setShowMailAddress( bool flag ) { getInstance() ->m_showMailAddress = flag; }
    static bool defaultShowMailAddress() { return false; }

    static QStringList& aboneNameList() { return getInstance() ->m_aboneNameList; }
    static void setAboneNameList( QStringList list ) { getInstance() ->m_aboneNameList = list; }
    static QStringList defaultAboneNameList() { return QStringList(); }

    static void addAboneName( QString name ) { getInstance() ->m_aboneNameList.append( name ); }
    static QStringList& aboneIDList() { return getInstance() ->m_aboneIDList; }
    static QStringList defaultAboneIDList() { return QStringList(); }

    static void setAboneIDList( QStringList list ) { getInstance() ->m_aboneIDList = list; }
    static void addAboneID( QString id ) { getInstance() ->m_aboneIDList.append( id ); }

    static bool aboneChain() { return getInstance() ->m_aboneChain; }
    static void setAboneChain( bool value ) { getInstance() ->m_aboneChain = value; }
    static bool defaultAboneChain() { return false; }

    static QStringList& aboneWordList() { return getInstance() ->m_aboneWordList; }
    static void setAboneWordList( QStringList list ) { getInstance() ->m_aboneWordList = list; }
    static void addAboneWord( QString word ) { getInstance() ->m_aboneWordList.append( word ); }
    static QStringList defaultAboneWordList() { return QStringList(); }

    static bool alwaysUseTab() { return getInstance() ->m_alwaysUseTab; }
    static void setAlwaysUseTab( bool on ) { getInstance() ->m_alwaysUseTab = on; }
    static bool defaultAlwaysUseTab() { return true; }

    // MarkTime(0) == special value (after last access)
    static int MarkTime() { return getInstance() ->m_MarkTime; }
    static void setMarkTime( int value ) { getInstance() ->m_MarkTime = value; }
    static int defaultMarkTime() { return 24; }

    static int sortOrder() { return getInstance() ->m_sortOrder; }
    static void setSortOrder( int order ) { getInstance() ->m_sortOrder = static_cast<SortOrder>( order ); }
    static int defaultSortOrder() { return Order_Mark; }

    static bool showAA() { return getInstance() ->m_showAA; }
    static void setShowAA( bool on ) { getInstance() ->m_showAA = on; }
    static bool defaultShowAA() { return false; }

    static int showNum() { return getInstance() ->m_showNum; }
    static void setShowNum( int num ) { getInstance() ->m_showNum = num; }
    static int defaultShowNum() { return 100; }

    static bool usePart() { return getInstance() ->m_usePart; }
    static void setUsePart( bool value ) { getInstance() ->m_usePart = value; }
    static bool defaultUsePart() { return true; }

    static bool useImageViewer() { return getInstance() ->m_useImageViewer; }
    static void setUseImageViewer( bool value ) { getInstance() ->m_useImageViewer = value; }
    static bool defaultUseImageViewer() { return true; }

    static bool useImagePopup() { return getInstance() ->m_useImagePopup; }
    static void setUseImagePopup( bool value ) { getInstance() ->m_useImagePopup = value; }
    static bool defaultUseImagePopup() { return true; }

    static bool useMosaic() { return getInstance() ->m_useMosaic; }
    static void setUseMosaic( bool value ) { getInstance() ->m_useMosaic = value; }
    static bool defaultUseMosaic() { return true; }

    static bool useKitaNavi() { return getInstance() ->m_useKitaNavi; }
    static void setUseKitaNavi( bool value ) { getInstance() ->m_useKitaNavi = value; }
    static bool defaultUseKitaNavi() { return true; }

    static QStringList& partMimeList() { return getInstance() ->m_partMimeList; }
    static void setPartMimeList( const QStringList value ) { getInstance() ->m_partMimeList = value; }
    static void setPartMimeList( const QString& value )
    { getInstance() ->m_partMimeList = QStringList::split( ',', value ); }
    static QStringList defaultPartMimeList();

    static QString userID() { return getInstance() ->m_userID; }
    static void setUserID( const QString id ) { getInstance() ->m_userID = id; }
    static QString defaultUserID() { return ""; }

    static QString password() { return getInstance() ->m_password; }
    static void setPassword( const QString pass ) { getInstance() ->m_password = pass; }
    static QString defaultPassword() { return ""; }

    static bool autoLogin() { return getInstance() ->m_autoLogin; }
    static void setAutoLogin( bool value ) { getInstance() ->m_autoLogin = value; }
    static bool defaultAutoLogin() { return false; }

    static bool checkResponsed() { return getInstance() ->m_checkResponsed; }
    static void setCheckResponsed( bool value ) { getInstance() ->m_checkResponsed = value; }
    static bool defaultCheckResponsed() { return true; }

    // read only (hidden setting)
    static bool copyOnClick() { return getInstance() ->m_copyOnClick; }
    static void setCopyOnClick( bool value ) { getInstance() ->m_copyOnClick = value; }
    static bool defaultCopyOnClick() { return false; }
};

#endif
