
#include "kitathreadpart.h"

#include <kio/job.h>
#include <khtml_part.h>
#include <kglobal.h>
#include <kaction.h>
#include <kstdaccel.h>
#include <kstdaction.h>

#include "kitahtmlpart.h"
#include "libkita/board.h"
#include "libkita/signalcollection.h"
#include "libkita/datmanager.h"

//static const char * version = $VERSION$;
static const char* version = "1.0";

typedef KParts::GenericFactory<KitaThreadPart> KitaThreadFactory;
K_EXPORT_COMPONENT_FACTORY( libkitapart, KitaThreadFactory )

KAboutData* KitaThreadPart::createAboutData()     // needed by GenericFactory
{
    KAboutData * about = new KAboutData(
                             "kitapart",
                             I18N_NOOP( "Kitapart plug-in" ),
                             version,
                             "2ch thread dat viewer plugin.",
                             KAboutData::License_GPL,
                             "(C) 2003 Konqueror-plugin no hito, (C) 2003 Hideki Ikemoto",
                             "http://pc.2ch.net/linux/",
                             "no-mail"
                         );
    about->addAuthor( "Hideki Ikemoto", "Initial widget writer", "ikemo@wakaba.jp", 0 );
    about->addAuthor( "Konqueror-plugin no hito", "Kparts & some hacks.", 0, "http://pc.2ch.net/linux" );
    return about; // will be passed to GenericFactory.
}

KitaThreadPart::KitaThreadPart( QWidget* parentWidget, const char*, QObject* parent, const char* name, const QStringList& )
        : KParts::ReadOnlyPart( parent, name )
        , m_threadview( 0 )
        , m_extension( 0 )
{
    KGlobal::locale() ->insertCatalogue( "kitapart" );

    m_threadview = new KitaThreadView( parentWidget ); // auto delete
    setInstance( KitaThreadFactory::instance() );
    setWidget( m_threadview );

    m_threadview->show();
}

KitaThreadPart::~KitaThreadPart()
{
    closeURL();
    if ( m_extension )
    {
        delete m_extension;
        m_extension = 0;
    }
}

KParts::BrowserExtension* KitaThreadPart::browserExtension() const
{
    return m_extension;
}

bool KitaThreadPart::openURL( const KURL& _url )
{
    kdDebug() << "KitaThreadPart::openURL _url: " << _url.url() << endl;
    m_url = _url;
    connect( m_threadview, SIGNAL( showThreadCompleted() ),
             this, SLOT( slotOpenURLResult() ) );

    m_threadview->showThread( m_url, Kita::DatManager::getKokoyonNum( m_url ) );
    emit started( 0 );
    return true;
}

bool KitaThreadPart::closeURL()
{
    return true;
}

void KitaThreadPart::slotOpenURLResult()
{
    disconnect( m_threadview, SIGNAL( showThreadCompleted() ),
                this, SLOT( slotOpenURLResult() ) );
    emit completed();
}

void KitaThreadPart::partActivateEvent ( KParts::PartActivateEvent* event )
{
    if ( event->activated() )
    {
	m_threadview->setFocus();
    }
}

KitaThreadBrowserExtension::KitaThreadBrowserExtension( KitaThreadPart* parent )
        : KParts::BrowserExtension( parent, "KitaThreadBrowserExtension" )
{
    // DND Drop enable: 1st stage.
    setURLDropHandlingEnabled( true ); // default: false
}

KitaThreadBrowserExtension::~KitaThreadBrowserExtension()
{}

// vim:sw=4:
