/**************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto , (c)2004 by 421                 *
*   ikemo@wakaba.jp                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
**************************************************************************/

#ifndef _KITANAVI_H_
#define _KITANAVI_H_

#include <qframe.h>
#include <qtabwidget.h>
#include <qtabbar.h>

class KitaThreadView;
class KitaNavi;
class KitaNaviTab;
class KitaThreadTabWidget;
class KURL;

/* mode */
enum {
    KITANAVI_SHOWRES,
    KITANAVI_EXTBYID,
    KITANAVI_EXTBYWORD,
    KITANAVI_EXTBYNAME,
    KITANAVI_SHOWRESTREE,
    KITANAVI_SHOWREVRESTREE,
    KITANAVI_TITLE
};


enum {
    KITANAVI_NAVI,     /* kita navi  */
    KITANAVI_IMAGENAVI /* image kita navi */
};


/*--------------------------------------*/

class KitaNavi : public QFrame
{

    Q_OBJECT

    static KitaNavi* m_kitanavi;

    KitaNaviTab* m_qtw;
    int m_navimode;

public:

    /* interfaces */
    static void createKitaNavi(QWidget* parent,KitaThreadTabWidget* threadTab);
    static KitaNavi* getKitaNavi();
    static void showKitaNavi( const KURL& datURL, int startnum, int endnum);
    static void showKitaNaviByID( const KURL& datURL, QString strid);
    static void showKitaNaviByWord( const KURL& datURL, QString query);
    static void showKitaNaviByName( const KURL& datURL, QString query );
    static void showKitaNaviResTree( const KURL& datURL, int resNum);
    static void showKitaNaviRevResTree( const KURL& datURL, int resNum );

private:
    KitaNavi(QWidget* parent,int navimode);
    ~KitaNavi();
    void addTab( int mode, const KURL& datURL, const QString& query, int startnum, int endnum );

protected:
    void windowActivationChange( bool );

private slots:
    void slotCloseCurrentTab();
    void slotEditFind();
    void slotChangeCaption( const QString& text );
    void slotIsKitaActive();

signals:
    void windowDeactivated();
    void isKitaActive();
    void kitaIsActive();
};


/*--------------------------------------*/

class KitaNaviTab : public QTabWidget
{
    Q_OBJECT
    int m_navimode;
    KitaThreadView* m_prevview;

public:
    KitaNaviTab(int mode,  QWidget* parent = 0, const char* name = 0, WFlags f = 0 );
    ~KitaNaviTab();

    QWidget* myRemovePage(QWidget* w, bool delCurView);

public slots:
    void slotCurrentChanged( QWidget * w);
};


/*--------------------------------------*/

class KitaNaviTabBar : public QTabBar
{
    Q_OBJECT
    int m_navimode;

public:
    KitaNaviTabBar(int mode, QWidget* parent = 0, const char* name = 0 )
            : QTabBar( parent, name ),m_navimode(mode){};
    ~KitaNaviTabBar(){};

protected:
    virtual void contextMenuEvent( QContextMenuEvent* e );
};



#endif


