/**************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto , (c)2004 by 421                 *
*   ikemo@wakaba.jp                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
**************************************************************************/

#ifndef KITADOMTREE_H
#define KITADOMTREE_H

#include <qthread.h>

#include "kitahtmlpart.h"

class KURL;
class QMutex;
class QSemaphore;

namespace DOM
{
class HTMLDocument;
class Element;
} 

namespace Kita
{
    class DatInfo;
}
class KitaRenderThread;

#define KITADOM_MAXRES 1200

class KitaDomTree
{
    /* basic informations */
    Kita::DatInfo* m_datInfo;
    KitaHTMLPart* m_threadPart;
    KURL m_url;
    int m_templateNum;
    int m_topNum;
    int m_bottomNum;
    int m_maxNum; 
    int m_kokoyonNum; /* number of kokomade yonda */

    /*
    1 <-- show --> m_templateNum <-- not shown -->
      m_topNum <-- shown ---> m_bottomNum <-- not shown --> m_maxNum 
    */

    /* for DOM  */
    DOM::HTMLDocument m_hdoc; /* root node of document*/
    DOM::Element m_res[ KITADOM_MAXRES + 1 ];
    bool m_resparsed[ KITADOM_MAXRES + 1 ]; /* already parsed */
    bool m_resshown[ KITADOM_MAXRES + 1 ]; /* already shown */
    DOM::Element m_header;
    DOM::Element m_footer;
    DOM::Element m_kokoyon;
    DOM::Element m_tugi100;
    DOM::Element m_mae100;
    bool m_appendtugi100;
    bool m_appendmae100;

    QSemaphore* m_semap;
    KitaRenderThread* m_krt;

    /*-------------------------------------------------------------*/

public:

    KitaDomTree( const DOM::HTMLDocument& hdoc, const KURL& datURL );
    ~KitaDomTree();

    /* parsing & rendering */

    /* (1) parseResInit
    -> (2) setDat
    -> (3) parseRes
    -> (4) appendRes  */

    void parseResInit( const KURL& datURL );
    void setDat( const QString& line, int num );
    bool parseRes( int num, int resnum );
    bool appendRes( int num, bool binsert );
    bool removeRes( int num );
    void redraw( bool force );

    void parseAllRes();
    void StopParseThread();

    /* utilities */

    bool isResShown( int num ) { return m_resshown[ QMIN( num, KITADOM_MAXRES - 1 ) ]; }
    int getTopResNumber() { return m_topNum;}
    int getBottomResNumber() { return m_bottomNum;}
    int getMaxResNumber() { return m_maxNum;}
    int getTemplateNumber() { return m_templateNum;}
    void setTemplateNumber( int tmp ) {m_templateNum = tmp;}

    bool isResDataSet( int num );
    QString getResStr( int num, QString qtstr );

    /* header Node, footer Node, kokomadeyonda Node, etc... */

    void appendTemplate();
    void appendFooter( int resnum );

    void appendKokoyon();
    void setKokoyonNum( int kokoyonNum ) {m_kokoyonNum = kokoyonNum;}
    int getKokoyonNum() { return m_kokoyonNum;}

    void appendTugi100();
    void removeTugi100();
    bool isTugi100Shown() { return m_appendtugi100;}

    void appendMae100();
    void removeMae100();
    bool isMae100Shown() { return m_appendmae100;}

    void createCommentNode( const QString& comment, const QString& idstr, int beforeBR, int afterBR, bool binsert );
    void createBeltNode( const QString& idstr );


    /*-------------------------------------------------------------*/

private:

    /* for init */
    void resetAllVar();

    /* utils */
    void appendColoredTextNode( DOM::Element &root, QString str, QString style );
    int checkIsNumValid( int num );

    /* for footer,header node, etc.. */
    DOM::Element createFooter( QString kitatype );
    void createKokoyon();
    void createTugi100();
    void createMae100();
};



/*-----------------------------------------------*/
/* class to parse dat file in background */

class KitaRenderThread : public QThread
{

    KitaDomTree* m_domtree;
    int m_maxNum;
    bool m_run;
    QMutex m_mutex;

public:

    KitaRenderThread( KitaDomTree* domtree ) : m_domtree( domtree ) {};
    ~KitaRenderThread() {};

    void setMaxNum( int maxNum );
    void stopRender();
    void mywait();
    virtual void run();
};


#endif
