/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@wakaba.jp                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/
#ifndef KITAFAVORITEBOARDS_H
#define KITAFAVORITEBOARDS_H

#include <qobject.h>
#include <kurl.h>

class QDomNode;

namespace Kita
{
    /**
    @author Hideki Ikemoto
    */
    class FavoriteBoards : public QObject
    {

        Q_OBJECT

        static FavoriteBoards* instance;
        QValueList<KURL> m_list;
        FavoriteBoards();
        ~FavoriteBoards();

        static void processChildNode( QDomNode& node );
    private:
        void notifyChange();
    public:
        static FavoriteBoards* getInstance();
        static void append( KURL& url );
        static void remove( KURL& url );
        static const QValueList<KURL>& boards();
        static bool readFromXML( QString& xml );
        static QString toXML();
        static void replace( QString fromURL, QString toURL );
    signals:
        void changed();
    };
}

#endif
