/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@wakaba.jp                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/
#include "favoriteboards.h"

#include "board.h"

#include <qdom.h>

using namespace Kita;

FavoriteBoards* FavoriteBoards::instance = 0;

FavoriteBoards::FavoriteBoards()
{}

FavoriteBoards::~FavoriteBoards()
{}

FavoriteBoards* FavoriteBoards::getInstance()
{
    if ( ! instance ) {
        instance = new FavoriteBoards();
    }
    return instance;
}

void FavoriteBoards::append( KURL& url )
{
    if ( ! getInstance() ->m_list.contains( url ) ) {
        getInstance() ->m_list.append( url );
        getInstance()->notifyChange();
    }
}

void FavoriteBoards::remove( KURL& url )
{
    if ( getInstance() ->m_list.contains( url ) ) {
        getInstance() ->m_list.remove( url );
        getInstance()->notifyChange();
    }
}

const QValueList<KURL>& FavoriteBoards::boards()
{
    return getInstance() ->m_list;
}

bool FavoriteBoards::readFromXML( QString& xml )
{
    FavoriteBoards * instance = FavoriteBoards::getInstance();
    instance->m_list.clear();

    QDomDocument document;
    if ( ! document.setContent( xml, true ) ) {
        return false;
    }
    QDomElement root = document.documentElement();

    QDomNode node = root.firstChild();
    while ( ! node.isNull() ) {
        if ( node.isElement() &&
                node.nodeName() == QString( "board" ) &&
                node.namespaceURI() == QString( "http://kita.sourceforge.jp/ns/board" ) ) {
            processChildNode( node );
        }
        node = node.nextSibling();
    }
    return true;
}

void FavoriteBoards::processChildNode( QDomNode& node )
{
    QDomNode urlNode = node.namedItem( "url" );
    QDomNode nameNode = node.namedItem( "name" );
    if ( ! urlNode.isElement() || ! nameNode.isElement() ) {
        return ;
    }

    QString urlText = urlNode.toElement().text();
    QString nameText = nameNode.toElement().text();

    KURL url = KURL( urlText );
    if ( url.isValid() ) {
        Kita::Board::setName( urlText, nameText );
        //FavoriteBoards::append( url );
        if ( !getInstance()->m_list.contains( url ) )
            getInstance()->m_list.append( url );
    }
}

QString FavoriteBoards::toXML()
{
    QDomDocument document;
    
    QDomProcessingInstruction pi = document.createProcessingInstruction( "xml", "version=\"1.0\"" );
    document.appendChild( pi );
    
    QDomElement root = document.createElementNS( "http://kita.sourceforge.jp/ns/boardlist", "boardlist" );
    document.appendChild( root );
    
    QValueList<KURL> boards = FavoriteBoards::boards();
    QValueList<KURL>::iterator it;
    for( it = boards.begin(); it != boards.end(); ++it ) {
        QDomElement board = document.createElementNS( "http://kita.sourceforge.jp/ns/board", "board" );
        root.appendChild( board );
        
        QString boardURL = (*it).url();
        QDomElement urlElement = document.createElement( "url" );
        board.appendChild( urlElement );
        urlElement.appendChild( document.createTextNode( boardURL ) );
    
        QString boardName = Kita::Board::getName( boardURL );
        QDomElement nameElement = document.createElement( "name" );
        board.appendChild( nameElement );
        nameElement.appendChild( document.createTextNode( boardName ) );
    }
    return document.toString( 0 );
}

void FavoriteBoards::replace( QString fromURL, QString toURL )
{
    QValueList<KURL>& boardList = FavoriteBoards::getInstance()->m_list;
    QValueList<KURL>::iterator it;
    for ( it = boardList.begin(); it != boardList.end(); ++it ) {
        QString url = (*it).url();
        if ( url.find( fromURL ) == 0 ) {
            url = url.replace( 0, fromURL.length(), toURL );
            boardList.remove( it );
            boardList.prepend( url );
            it = boardList.begin();
        }
    }
    FavoriteBoards::getInstance()->notifyChange();
}

void FavoriteBoards::notifyChange()
{
    emit changed();
}

#include "favoriteboards.moc"
