/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@wakaba.jp                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/
#ifndef KITACACHE_H
#define KITACACHE_H

#include <qstring.h>

class KURL;

namespace Kita
{

    /**
    @author Hideki Ikemoto
    */
    class Cache
    {
        static QString baseDir();
	static QString subDir( const KURL& url );
	static QString hashString( const KURL& url );
	static QString getImgBaseDir();
	static QString getImgFileName( const KURL& src);

    public:
        static QString getPath( const KURL& url );
	static QString getImgPath( const KURL& url);
	static QString getImgIdxPath( const KURL& url);	
    };

}

#endif
