/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@wakaba.jp                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/
#include "cache.h"

#include "kita_misc.h"

#include <kurl.h>
#include <kglobal.h>
#include <kstandarddirs.h>
#include <kprotocolmanager.h>

using namespace Kita;

QString Cache::baseDir()
{
    QString dir = KGlobal::dirs() ->saveLocation( "cache", "kita" );
    if ( dir[ dir.length() - 1 ] != '/' )
        dir += "/";

    return dir;
}

QString Cache::getPath( const KURL& datURL )
{
    QString path = Kita::datToCache( datURL.url() );
    if ( path == QString::null ) return QString::null;
    return baseDir() + path;
}


/*------------------------------------*/
/* for Image files                    */


/* public */
QString Cache::getImgPath( const KURL& url )
{
    return baseDir() + "image/" + subDir( url ) + "/" + getImgFileName( url );
}


/* path for image index */ /* public */
QString Cache::getImgIdxPath( const KURL& url )
{
    return getImgPath( url ) + ".idx";
}


/* private */
QString Cache::subDir( const KURL& url )
{
    QString host = url.host().lower();
    int l = host.length();
    for ( int i = 0; i < l; i++ ) {
        if ( host[ i ].isLetter() && ( host[ i ] != 'w' ) ) {
            return QString( host[ i ] );
        }
    }
    return "0";
}


/* private */
QString Cache::hashString( const KURL& url )
{
    unsigned long hash = 0x00000000;
    QCString u = url.url().latin1();
    for ( int i = u.length(); i--; ) {
        hash = ( hash * 12211 + u[ i ] ) % 2147483563;
    }

    QString ret;
    ret.sprintf( "%08lx", hash );

    return ret;
}


/* private */
QString Cache::getImgBaseDir()
{
    QString basedir = baseDir() + "image/";    
    return basedir;
}


/* private */
QString Cache::getImgFileName( const KURL& url )
{
    QString host = url.host().lower();
    host.replace( QChar( '.' ), QChar( '_' ) );

    QString filename = url.fileName().lower();
   
    return host +  "_" +  hashString( url ) + filename;
}
