/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KITABOARD_H
#define KITABOARD_H

#include <kurl.h>

#include <qptrlist.h>
#include <qxml.h>
#include <qdict.h>
#include <qeucjpcodec.h>

#include "thread.h"

/**
@author Hideki Ikemoto
*/

class QCp932Codec;

namespace Kita
{
    class Thread;

    class Board
    {
        QString m_boardURL;
        QString m_boardName;
        static QDict<Board>* m_boardDict;
        static QCp932Codec* m_cp932Codec;
        static QEucJpCodec* m_eucJpCodec;
        Board( const QString& boardURL, const QString boardName = QString::null );
        static Board* getByURL( const QString& boardURL );
    protected:
        Board();
    public:
        ~Board();
        static const QString getID( const QString& boardURL );

        static void setName( const QString& boardURL, const QString& boardName );
        static const QString& getName( const QString& boardURL );

        static const QPtrList<Thread> getThreadList( const QString& boardURL );
        static void replace( const QString& fromURL, const QString& toURL );

        static bool isWritingSupported( const KURL& boardURL );
    };

    class NullBoard : public Board
    {
    public:
        NullBoard();
        ~NullBoard();
    };
}

#endif
