/***************************************************************************
 *   Copyright (C) 2004 by Kita Developers                                 *
 *   ikemo@users.sourceforge.jp                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "account.h"

#include <config.h>

#include <kurl.h>

#include <kio/slaveconfig.h>
#include <kio/netaccess.h>
#include <kio/jobclasses.h>
#include <kio/job.h>

#include <qregexp.h>
#include <qapplication.h>

using namespace Kita;

Account* Account::instance = 0;

Account* Account::getInstance()
{
    if ( instance == 0 ) {
        instance = new Account();
    }
    return instance;
}

Account::Account()
        : m_isLogged( false )
{}

Account::~Account()
{}

bool Account::login( const QString& userID, const QString& password )
{
    return getInstance()->loginInternal( userID, password );
}

bool Account::loginInternal( const QString& userID, const QString& password )
{
    m_data.resize( 0 );

    KURL url( "https://2chv.tora3.net/futen.cgi" );
    QString postData = QString("ID=") + userID + QString("&PW=") + password;

    KIO::SlaveConfig::self() ->setConfigData( "https",
            url.host(),
            "UserAgent",
            "DOLIB/1.00" );
    m_job = KIO::http_post( url, postData.utf8(), false );

    connect( m_job, SIGNAL( data( KIO::Job*, const QByteArray& ) ),
             SLOT( slotReceiveData( KIO::Job*, const QByteArray& ) ) );
    connect( m_job, SIGNAL( result( KIO::Job* ) ), SLOT( slotResult( KIO::Job* ) ) );
    m_job->addMetaData( "customHTTPHeader",
                        QString( "X-2ch-UA: Kita/%1" ).arg( VERSION ) );
    m_job->addMetaData( "content-type",
                        "Content-Type: application/x-www-form-urlencoded" );

    enter_loop();

    return m_isLogged;
}

void Account::slotReceiveData( KIO::Job*, const QByteArray& data )
{
    QCString str( data, data.size() );
    m_data += str;
}

void Account::slotResult( KIO::Job* job )
{
    m_job = 0;
    if ( job->error() )
    {
        job->showErrorDialog();
    }

    QString str( m_data );
    QRegExp regexp( "SESSION-ID=(.*)" );
    if ( regexp.search( str ) == -1 )
    {
        m_sessionID = QString::null;
        m_isLogged = false;
    }
    else
    {
        QString value = regexp.cap( 1 );

        QRegExp error( "^ERROR:p+$" );
        if ( error.search( value ) == -1 )
        {
            m_isLogged = true;
            m_sessionID = value;
        }
        else
        {
            m_isLogged = false;
            m_sessionID = QString::null;
        }
    }
    qApp->exit_loop();
}

// from netaccess.cpp
void qt_enter_modal( QWidget* widget );
void qt_leave_modal( QWidget* widget );

void Account::enter_loop()
{
    QWidget dummy( 0, 0, WType_Dialog | WShowModal );
    dummy.setFocusPolicy( QWidget::NoFocus );
    qt_enter_modal( &dummy );
    qApp->enter_loop();
    qt_leave_modal( &dummy );
}

#include "account.moc"
