/***************************************************************************
*   Copyright (C) 2003-2004 by Hideki Ikemoto                             *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/
#ifndef KITAACCESS_H
#define KITAACCESS_H

#include <kurl.h>

#include <qobject.h>

namespace KIO
{
    class Job;
}

namespace Kita
{
    class Thread;

    /**
    @author Hideki Ikemoto
    */
    class Access : public QObject
    {
        Q_OBJECT

    public:
        Access( const KURL& datURL ) : m_datURL( datURL ), m_currentJob( 0 ) {};
        virtual ~Access() {};

        QString get();
        void killJob();
        void stopJob();
        int serverTime();
        QString getcache();
        QString getupdate();
        int responseCode();
        static bool deleteLog( const Thread* thread );

    protected:
        void writeCacheData();
        void make_cacheDir( const KURL& url );

        const KURL m_datURL;
        KIO::Job* m_currentJob;
        QString m_threadData;
        QString m_header;
        QString m_orgData;
        bool m_firstReceive;
        bool m_invalidDataReceived;

    private slots:
        void slotReceiveThreadData( KIO::Job* job, const QByteArray& data );
        void slotThreadResult( KIO::Job* job );

    signals:
        void redirection( const QString& );
        void receiveData( const QString& );
        void finishLoad();
    };

    class OfflawAccess : public Access
    {
        Q_OBJECT

    public:
        OfflawAccess( const KURL& datURL ) : Access( datURL ) {};
        virtual ~OfflawAccess() {};

        QString get();

    private slots:
        void slotReceiveThreadData( KIO::Job* job, const QByteArray& data );
        void slotThreadResult( KIO::Job* job );
    };
}

#endif
