/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto, 2004 by 421                     *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KITATHREADTABWIDGET_H
#define KITATHREADTABWIDGET_H

#include "kitatabwidgetbase.h"

class KitaThreadView;


/* mode of tabwidget */
enum {
    TABMODE_THREADVIEW,
    TABMODE_KITANAVI
};


/* mode of kitanavi */
enum {
    KITANAVI_SHOWRES,
    KITANAVI_EXTBYID,
    KITANAVI_EXTBYWORD,
    KITANAVI_EXTBYNAME,    
    KITANAVI_SHOWRESTREE,
    KITANAVI_SHOWREVRESTREE,    
    KITANAVI_TITLE    
};


/*-----------------------------------------------*/    


class KitaThreadTabWidget : public KitaTabWidgetBase
{
    Q_OBJECT

    int m_mode;
	
public:
    KitaThreadTabWidget( int mode, QWidget* parent = 0, const char* name = 0, WFlags f = 0 );
    ~KitaThreadTabWidget();
    
public slots:
    void slotShowMainThread( const KURL& datURL, bool withNewTab );
    void slotShowKitaNavi( int mode, const KURL& datURL, const QString& query, int startnum, int endnum );
    void slotCloseThreadTab( const KURL& url );    

private:
    KitaThreadView* createView( QString label );
    void connectSignals();
    KitaThreadView* findMainView( const KURL& url );
    KitaThreadView* isThreadView( QWidget* w );
    
private slots:
    void slotUpdateThreadTab( const KURL& url );

    
protected:
    virtual void deleteWidget( QWidget* w );

    
    /*------------------------------------*/
    /* KitaThreadView actions */

private:
    void setupActions();
    
public slots:
    void slotOpenBrowser( int idx = -1 );
    void slotCopyURL( int idx = -1 );
    void slotCopyTitleURL( int idx = -1 );    
    void slotFocusSearchCombo();
    void slotSearchNext();
    void slotSearchPrev();
    void slotGobackAnchor();
    void slotGotoHeader();
    void slotGotoFooter();
    void slotReloadButton();
    void slotStopLoading();        
    void slotDeleteButtonClicked();    
};


/*--------------------------------------------------*/


class KitaThreadTabBar : public KitaTabBarBase
{
    Q_OBJECT

public:
    KitaThreadTabBar( QWidget* parent = 0, const char* name = 0 );
    ~KitaThreadTabBar();

private:
    virtual void showPopupMenu( int idx, QPoint global );
};


/*------------------------------------------------------------*/


class KitaThreadDock : public KitaDockWidgetBase{

    Q_OBJECT
	KitaThreadTabWidget* m_threadTab;
	
public:
    KitaThreadDock( KDockManager* dockManager,
	    const char* name,
	    const QPixmap &pixmap,
	    QWidget* parent = 0L,
	    const QString& strCaption = QString::null,
	    const QString& strTabPageLabel = QString::fromLatin1( " " ),
	    WFlags f = 0);
    ~KitaThreadDock();

    /* Main Thread view */
    
public: 
    KitaThreadTabWidget* setupAsMainView();

public slots:
    void slotShowThread( const QString& datURL, bool withNewTab );

 
    /* Kita Navi */ 
 
public:
    KitaThreadTabWidget* setupAsKitaNavi();
    void  connectNaviSignals();

private slots:
    void slotShowKitaNavi( const KURL& datURL, int startnum, int endnum);
    void slotShowKitaNaviByID( const KURL& datURL, QString strid);
    void slotShowKitaNaviByWord( const KURL& datURL, QString query);
    void slotShowKitaNaviByName( const KURL& datURL, QString query );    
    void slotShowKitaNaviResTree( const KURL& datURL, int resNum);
    void slotShowKitaNaviRevResTree( const KURL& datURL, int resNum );    
};



#endif
