/***************************************************************************
*   Copyright (C) 2004 by Hideki Ikemoto , (c) 2004 by 421                *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#include "kitaboardtabwidget.h"
#include "kitaboardview.h"
#include "libkita/signalcollection.h"

#include <klocale.h>

/*--------------------------------------------------------------*/


KitaBoardTabWidget::KitaBoardTabWidget( QWidget* parent, const char* name, WFlags fl )
    :KitaTabWidgetBase( parent, name, fl )
{
    KitaBoardView* view = new KitaBoardView( this );
    addTab( view, i18n( "board name" ) );
}


KitaBoardTabWidget::~KitaBoardTabWidget(){}


/* public slot */
void KitaBoardTabWidget::loadBoardList()
{
    static_cast < KitaBoardView* > ( page( 0 ) )->loadBoardList();
}
    
/* public slot */
void KitaBoardTabWidget::setFont( const QFont& font )
{
    static_cast < KitaBoardView* > ( page( 0 ) )->setFont( font );
}


/* protected */ /* virtual */
void KitaBoardTabWidget::deleteWidget( QWidget* w ){}


/*--------------------------------------------------------------*/


KitaBoardDock::KitaBoardDock( KDockManager* dockManager,
		    const char* name,
		    const QPixmap &pixmap,
		    QWidget* parent,
		    const QString& strCaption,
		    const QString& strTabPageLabel,
		    WFlags f )
    :KitaDockWidgetBase( dockManager, name, pixmap, parent, strCaption, strTabPageLabel, f ){}


KitaBoardDock::~KitaBoardDock()
{
    if( m_boardTab ) delete m_boardTab;
}


/* setup & create KitaBoardDock */ /* public */
KitaBoardTabWidget* KitaBoardDock::setup()
{
    /* create KitaNaviTabWidget */
    m_boardTab = new KitaBoardTabWidget( this, "Board" );
    setWidget( m_boardTab );

    Kita::SignalCollection* signalCollection = Kita::SignalCollection::getInstance();
    connect( signalCollection, SIGNAL( switchToBoard() ),
	     SLOT( slotShowDock() ) );
    
    return m_boardTab;
}
