/* $Id: emoji.c,v 1.5 2006/01/10 13:02:34 ichiro Exp $ */
/*
 * Copyright (c) 2004, 2005, 2006
 *	Ichiro FUKUHARA <ichiro@ichiro.org>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Ichiro FUKUHARA.
 * 4. The name of the company nor the name of the author may be used to
 *    endorse or promote products derived from this software without specific
 *    prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ICHIRO FUKUHARA ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ICHIRO FUKUHARA OR THE VOICES IN HIS HEAD BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <errno.h>
#include <sys/types.h>
#include <regex.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <net/if.h>
#include <sys/time.h>
#include <sys/param.h>

#include "kircd.h"

#ifdef HAVE_ICONV
#include <iconv.h>
#endif

extern int debug;

int emoji_encode(unsigned char *src, int phone_type)
{
        int i, j, k, len;
	int sum;
	unsigned char buffer[IRC_MAX * 2];
	unsigned char add[IRC_MAX];

	bzero(buffer, sizeof(buffer));
        len = strlen((char *)src);

	for (i = 0, j = 0; i < len; i++) {
		sum = src[i] << 8 | src[i+1];
		if ((phone_type == AU_EZWEB) && 
		    (sum >= 0xF340 && sum <= 0xF9FC)) {
			DPRINTF(1, ("AU emoji encode %04x\n", sum));
			for (k = 0; k < DAT_ROW; k++) {
			    if (emoji[k][AU_KEY] == sum) {
				sprintf(add, " emoji%03d ", emoji[k][DAT_NUM]);
				strncat(buffer, add, 10);
				j += 10;
				break;
			    }
			}
			i++;
		} else if (((phone_type == DOCOMO_PDC) ||
			    (phone_type == DOCOMO_FOMA)) &&
			   (sum >= 0xF89F && sum <= 0xF9FC)) {
			DPRINTF(1, ("found Docomo emoji %04x\n", sum));
			for (k = 0; k < DAT_ROW; k++) {
			    if (emoji[k][D_KEY] == sum) {
				sprintf(add, " emoji%03d ", emoji[k][DAT_NUM]);
				strncat(buffer, add, 10);
				j += 10;
				break;
			    }
			}
			i++;
		} else {
			buffer[j] = src[i];
			j++;
		}
	}
	buffer[j + 1] = '\0';

	DPRINTF(1, ("emoji encode:(%d)%s\n", j, buffer));
	strcpy(src, buffer);

	return j + 1;
}

int emoji_decode(unsigned char *src, int phone_type)
{
        int k, len, id;
	unsigned char *p, *q;
        unsigned char buffer[IRC_MAX * 2];
        unsigned char add[IRC_MAX * 2];

        bzero(buffer, sizeof(buffer));
        len = strlen((char *)src);

	q = src;
	p = src;
	while (p != NULL){
		if ((p = strstr(q, "emoji")) != NULL) {
			id = atoi(p + 5);
			DPRINTF(1, ("emoji found ID:%03d\n", id));
			strncat(buffer, q, (int)(p - q) - 1);
			q = p + 9;

			for (k = 0; k < DAT_ROW; k++) {
			    if (emoji[k][DAT_NUM] == id) {
				if (phone_type == AU_EZWEB) {
				    sprintf(add, "<img localsrc=\"%d\">",
					emoji[k][AU_STR]);
				    strcat(buffer, add);
				} else if (phone_type == DOCOMO_PDC) {
				    sprintf(add, "%c%c",
					(emoji[k][D_KEY]>>8) & 0x00FF,
					emoji[k][D_KEY] & 0x00FF);
				    strcat(buffer, add);
				} else if (phone_type == DOCOMO_FOMA) {
				    sprintf(add, "&#x%04x;", emoji[k][D_STR]);
				    strcat(buffer, add);
				}
			    }
			}
                } else {
			strncat(buffer, q, len - (int)(q - src));
                }
        }
	strcat(buffer, "\0");

        strcpy(src, buffer);

        return 0;
}

