/* $Id: httpd.c,v 1.74 2006/01/04 02:34:45 ichiro Exp $ */
/*
 * Copyright (c) 2004, 2005, 2006
 *	Ichiro FUKUHARA <ichiro@ichiro.org>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Ichiro FUKUHARA.
 * 4. The name of the company nor the name of the author may be used to
 *    endorse or promote products derived from this software without specific
 *    prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ICHIRO FUKUHARA ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ICHIRO FUKUHARA OR THE VOICES IN HIS HEAD BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <ctype.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/fcntl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <net/if.h>
#include <sys/time.h>
#include <sys/param.h>

extern int debug;

#include "kircd.h"
#include "httpd.h"

void httpd_proc(struct tparam *, int);
int auth_proc(int, struct tparam *, char *, char *);
int easy_regist(int, struct tparam *, char *, char *);
void print_command_page(struct tparam *);

gpointer
httpd(gpointer param)
{
	struct tparam *th2;
	int s2, s3;

	th2 = (struct tparam *)param;
	s2 = th2->server_socket;

	for (;;) {
		s3 = accept(s2, NULL, NULL);
		if (s3 < 0) {
			printf("error: accepting a socket.\n");
			exit (1);
		}
		usleep(100000);
		httpd_proc(th2, s3);

		close(s3);
	}
}

void httpd_proc(struct tparam *th2, int socket)
{
	time_t timer;
	struct tm *date;
	
	char buf[SBUFLEN];
	char meth_name[M_LEN];
	char channel[C_NAME], channel2[C_NAME];
	char uri_addr[URI_LEN];
	char header[IRC_MAX];
	char message[IRC_MAX];
	char post_message[IRC_MAX * 2]; /* include url_encode mergin */
	char *s, *q;
	char cmd_cname[C_NAME], cmd_cmd[CMD_LEN];
	char cmd_tsel[CMD_LEN];
	char cmd_buf[IRC_MAX];
	char subtopic[SUBTOPIC_LEN];

	int n = 0;
	int r_fd = 0;
	char http_ver[4];

	int number = 0;
	int subusernum = 0;
	int update = 0;
	int start_number = 0;
	int post_length = 0;
	int post_ch_number = 0;

	/* bzero */
	bzero(buf, sizeof(buf));
	bzero(meth_name, sizeof(meth_name));
	bzero(uri_addr, sizeof(uri_addr));
	bzero(header, sizeof(header));
	bzero(message, sizeof(message));
	bzero(channel, sizeof(channel));
	bzero(channel2, sizeof(channel2));
	bzero(post_message, sizeof(post_message));
	bzero(th2->postdata, sizeof(th2->postdata));

	bzero(cmd_cname, sizeof(cmd_cname));
	bzero(cmd_cmd, sizeof(cmd_cmd));
	bzero(cmd_buf, sizeof(cmd_buf));
	bzero(subtopic, sizeof(subtopic));

	/* get buffer from stream */
	if (read(socket, buf, SBUFLEN) <= 0 ) {
		printf("error: reading a request.\n");
		return;
	}

	if ((sscanf(buf, "%s %s HTTP/%s\n",
			meth_name, uri_addr, http_ver)) < 3) {
		printf("error: catch strings of request.\n");
	}

	DPRINTF(1, ("meth_name= %s\n", meth_name));
	DPRINTF(1, ("uri_addr= %s\n", uri_addr));
	DPRINTF(1, ("http_ver= %s\n", http_ver));
	DPRINTF(1, ("---------------------------\n"));
	DPRINTF(1, ("BUF:%s\n", buf));

	/* init header */
	strcpy(header, http_header0);

	/* POST session */
	if ((strcmp(meth_name, "POST")) == 0) {
		DPRINTF(0, ("status: POST Session\n"));

	    	/* registration page (EasyAccess) */
		if (strcmp(uri_addr + 1, "regist") == 0) {
		    if (!th2->regist_done || !th2->auth_flag) {
			DPRINTF(0, ("EasyAccess registration page\n"));
			if (easy_regist(socket, th2, buf, header) < 0) {
			    DPRINTF(0, ("EasyAccess registration Failed\n"));
			}
		    }
		    strcpy(uri_addr, "/");
		    goto index_start;
		}

		/* wait for flags clear */
		while ((!th2->t_empty) || (th2->t_lock)) {
			usleep(10000); /* 10ms */
		}
		th2->t_lock = 1;	/* now writing */

		/* Get length of post data */
		if ((s = strstr(buf, "Content-Length: ")))
			post_length = atoi(s + 16);

		/* if cannot read 'm=' or 'cname=', read more */
		if((!strstr(buf, "m=")) && (!strstr(buf, "cname="))) {
			/* zero clear buffer */
			bzero(buf, sizeof(buf));
			read(socket, buf, post_length);

			DPRINTF(0, ("POST data: %s\n", buf));
		}

		/* Get post message */
		if ((s = strstr(buf, "m="))) {
			sprintf(post_message, "%.*s",
				post_length - 2, s + 2);

			if (post_length < 3) {
				/* clear trans. empty flag */
				th2->t_empty = 1;
                                th2->t_lock = 0;
                                goto index_start;
			}

			/* URL decord */
			url_decode_jis(post_message);
			DPRINTF(0, ("decode: %s\n", post_message));

			/* Get channel number to post */
			sscanf(uri_addr + 1, "channel%d",
				&post_ch_number);

			/* channel decode (%hoge -> #hoge:*.jp) */
			channel_decode(channel2,
					th2->name[post_ch_number]);

			/* transfer message to data buffer */
			sprintf(th2->postdata,
				":%s PRIVMSG %s :%s\r\n",
				 th2->real_nickname, channel2,
				 post_message);

			/* store own messages */
			strcpy(th2->l_buff, th2->postdata);
			priv_recv(th2);
			bzero(th2->l_buff, sizeof(th2->l_buff));

			/* show only own throw message */
			update = 1;
			th2->read_count[post_ch_number]--;

			/* clear trans. empty flag */
			th2->t_empty = 0;
			th2->t_lock = 0;

			goto index_start;
		} else if ((s = strstr(buf, "cname="))) {
			/* clear buffer */
			bzero(cmd_cname, sizeof(cmd_cname));        
			bzero(cmd_cmd, sizeof(cmd_cmd));    
			bzero(cmd_tsel, sizeof(cmd_tsel));

			if (post_length < 39) {
			   /* 39: cname=&cname2=&cmd=join&topic=&t_sel=on */
			   /* clear trans. empty flag */
				th2->t_empty = 1;
                                th2->t_lock = 0;
                                goto index_start;
			}

			sprintf(post_message,	/* XXX temporary used */
				"%.*s", post_length, s);

			q = strtok(post_message, "&");
			if (q != NULL) strcpy(cmd_cname, q + 6);
							/* 6: cname= */

			q = strtok(NULL, "&");
			if (q != NULL) {
				if (strlen(cmd_cname) == 0)
					strcpy(cmd_cname, q + 7);
							/* 7: cname2= */
			}

			q = strtok(NULL, "&");
			if (q != NULL) {
				strcpy(cmd_cmd, q + 4);	/* 4: cmd= */
			}

			q = strtok(NULL, "&");
			if (q != NULL) {
				strcpy(cmd_buf, q + 6); /* 6: topic= */
			}

			q = strtok(NULL, "&");
			if (q != NULL) {
				strcpy(cmd_tsel, q + 6);
			}				/* 6: t_sel= */

			DPRINTF(0, ("cname=%s\ncmd=%s\ntopic=%s\nt_sel=%s\n",
				cmd_cname, cmd_cmd, cmd_buf, cmd_tsel));

			/* make command message */
			if (strcmp(cmd_cmd, "join") == 0) {
			   if(strlen(cmd_cname) > 0){
				url_decode_rawdata(channel, cmd_cname);
				/* send join */
				send_join(th2, channel);
			   }
			} else if (strcmp(cmd_cmd, "part") == 0) {
			   if(strlen(cmd_cname) > 0){
				url_decode_rawdata(channel, cmd_cname);
				/* send part */
				send_part(th2, channel);
			   }
			} else if (strcmp(cmd_cmd, "nick") == 0) {
			   if(strlen(cmd_buf) > 0){
				sprintf(th2->postdata, ":%s NICK %s\r\n",
					th2->real_nickname, cmd_buf);
			   }
			} else if (strcmp(cmd_cmd, "topic") == 0) {
			   if((strlen(cmd_cname) > 0) &&
				(strlen(cmd_buf) > 0)){
				url_decode_rawdata(channel, cmd_cname);
				/* any -> #hoge*.jp */
				channel_decode(channel2, channel);
				url_decode_jis(cmd_buf);
				sprintf(th2->postdata, ":%s TOPIC %s :%s\r\n",
					th2->real_nickname,
					channel2, cmd_buf);
			   }
			}

			if (strcmp(cmd_tsel, "on") == 0) {
				/* change to show topic */
				th2->show_topic = 1;
			} else if (strcmp(cmd_tsel, "off") == 0) {
				th2->show_topic = 0;
			}

			/* clear trans lock and empty flag */
			th2->t_empty = 0;
			th2->t_lock = 0;

			goto command_start;
		}
	}	/* POST */

#if 0
	/* favicon.ico */
	if (strstr(uri_addr + 1, "favicon.ico")) {
		DPRINTF(0, ("favicon session\n"));
		if ((r_fd = open(uri_addr, O_RDONLY,
				 0666)) == -1) {
			printf("favicon.ico file not found\n");
		} else if (strcmp(http_ver,"1.0") == 0) {
			send_msg(socket, ico_header10);
			while((n = read(r_fd, buf, HTTPBUF)) > 0) {
			   if (write(socket, buf, n) != n) {
			   	printf("error: writing a file\n");
				break;
			   }
			} /* while */
		} else if (strcmp(http_ver,"1.1") == 0) {
			printf("ver 1.1\n");

		}

		close(r_fd);
		send_msg(socket, http_footer);
	} /* favicon.ico */
#endif
	/* GET */
	if (strcmp(meth_name, "GET") == 0) {
index_start:
	    /* main entrance (authentication) */
	    if (auth_proc(socket, th2, buf, header) < 0)
		return;

	    /* start UserList Sub page (GET) */
	    if (strcmp(uri_addr + 1, "user") == 0) {
		DPRINTF(0, ("UserList Sub page\n"));

		sprintf(message, "User list / Topic<br>");
		send_buf(th2, message);

		for (n = 0; n <= th2->ch_count; n++) {
		   if (strlen(th2->topic[n]) > 0) {
			strncpy(subtopic, th2->topic[n], 14);
			if (strlen(th2->topic[n]) > 14) {
				strcat(subtopic, "...\0");
			} else {
				strcat(subtopic, "\0");
			}
		   }
			if (n < 9) {
			    sprintf(message,
			    "%d <a accesskey=\"%d\" href=\"subuser%d\">%s</a> "
			    "[%d] <a href=\"subtopic%d\">%s</a><br>",
			    n, n, n, th2->name[n], th2->member_count[n],
			    n, subtopic);
			} else {
			    sprintf(message,
			    "* <a href=\"subuser%d\">%s</a> "
			    "[%d] <a href=\"subtopic%d\">%s</a><br>",
			    n, th2->name[n], th2->member_count[n],
			    n, subtopic);
			}           
			send_buf(th2, message);

			strcpy(subtopic, "\0");
		}

		send_buf(th2,
			"<hr><a accesskey=\"9\" href=\"/\">back[9]</a>");
		send_msg(socket, th2, header);
		return;
	    }

	    /* start UserList SubSub page (GET) */
            if ((sscanf(uri_addr + 1, "subuser%d", &subusernum)) == 1) {
		DPRINTF(0, ("UserList SubSub page\n"));

		sprintf(message,
		        "users:%s<br>", th2->member_names[subusernum]);
		send_buf(th2, message);

		send_buf(th2,
			"<hr><a accesskey=\"9\" href=\"/\">back[9]</a>");
		send_msg(socket, th2, header);

		return;
	    }

	    /* start topic jump from subtopic tag (GET) */
	    if (sscanf(uri_addr + 1, "subtopic%d", &subusernum) == 1) {
		DPRINTF(0, ("SubTopic page\n"));

		sprintf(message,
			"Topic:%s<br>", th2->topic[subusernum]);
		send_buf(th2, message);

		send_msg(socket, th2, header);

		return;
	    }

	    /* start COMMAND page */
	    if (strcmp(uri_addr + 1, "cmd") == 0) {
command_start:
		DPRINTF(0, ("COMMAND page\n"));
		print_command_page(th2);

		/* send data */
		send_msg(socket, th2, header);

		return;
	    }

	    /* start index of each channels */
	    if (sscanf(uri_addr + 1, "channel%d", &number) == 1) {
		DPRINTF(0, ("Sub index session\n"));
		/* check update or not */
		if (number >= 50) {
			update = 1;
			number -= 50;
		}

		/* print TOPIC */
		if (th2->show_topic) {
		    if (strlen(th2->topic[number]) > 0) {
			sprintf(message, "%s<br>", th2->topic[number]);
			send_buf(th2, message);
		    }
		}

		/* print FORM */
		sprintf(message,
			"<form action=\"/channel%d\" method=\"post\">", number);
		send_buf(th2, message);
		send_buf(th2,
			 "<input type=\"text\" name=\"m\" size=\"10\">");
		send_buf(th2,
			 "<input type=\"submit\" value=\"send\"></form>");
		send_buf(th2,
			"<a accesskey=\"8\" href=\"/\">back[8]</a><hr>");

		if (update)
			start_number = th2->read_count[number];
		else
			start_number = 0;

		if (th2->line_reverse) {
			for (n = start_number;
			     n < th2->history_count[number]; n++) {
				sprintf(message, "%s",
					th2->data[number][n]);
				send_buf(th2, message);
			}
		} else {
			for (n = th2->history_count[number] - 1;
			     n >= start_number; n--) {
				sprintf(message, "%s",
					th2->data[number][n]);
				send_buf(th2, message);
			}
		}
		th2->read_count[number] = th2->history_count[number];

		send_msg(socket, th2, header);

		update = 0;

		return;
	    }

	    /* start main index */
	    if (strcmp(uri_addr, "/") == 0) {
	    DPRINTF(0, ("start main index\n"));
		for (n = 0; n <= th2->ch_count; n++) {
		    if (n < 9) {
			sprintf(message,
			    "%d <a accesskey=\"%d\" href=\"channel%d\">%s</a> "
			    "<a href=\"channel%d\">(%d)</a><br>",
			    n, n, n, th2->name[n],
			    n + 50, th2->history_count[n] -
			    th2->read_count[n]);
		    } else {
			sprintf(message,
			    "* <a href=\"channel%d\">%s</a> "
			    "<a href=\"channel%d\">(%d)</a><br>",
			    n, th2->name[n],
			    n + 50, th2->history_count[n] -
			    th2->read_count[n]); 	
		    }
		    send_buf(th2, message);
		}
		sprintf(message,
		    "<hr>9 <a accesskey=9 href=\"cmd\">"
		    "cmd page</a><br>");
		send_buf(th2, message);

		sprintf(message,
		    "* <a href=\"user\">user/topic</a><br>");
		send_buf(th2, message);

		sprintf(message,
		    "<br><left>kircd Ver %s </left>", VERSION);
		send_buf(th2, message);

		send_msg(socket, th2, header);

		return;
	    }

	    /* logout */
	    if (th2->auth_method == 2) { /* Easy Access */
		if (strcmp(uri_addr + 1, "logout") == 0) {
		    DPRINTF(0, ("status: LOGOUT Session\n"));
		    th2->auth_flag = 0;

		    send_buf(th2, "logout done...");
		    send_msg(socket, th2, header);

		    return;
		}
		if (strcmp(uri_addr + 1, "logoff") == 0) {
		    DPRINTF(0, ("status: LOGOFF Session\n"));
		    th2->auth_flag = 0;
		    th2->regist_done = 0;
		    bzero(th2->uid, sizeof(th2->uid));

		    send_buf(th2, "logoff done...");
		    send_buf(th2, "Please register again.");
		    send_msg(socket, th2, header);

		    return;
		}
	    }
	} /* GET */
}

void send_buf(struct tparam *th, char *addmsg)
{
	int buf_len, add_len;

	buf_len = strlen(th->send_buf);
	add_len = strlen(addmsg);

	if (th->send_buflen < (buf_len + add_len + 1)) {
		DPRINTF(1, ("SEND_BUF %d -> ", th->send_buf));
		th->send_buflen = th->send_buflen + HTTPBUF;
		th->send_buf = (char *)realloc(th->send_buf,
				th->send_buflen);
		DPRINTF(1, ("%d\n", th->send_buf));
	}

	strcat(th->send_buf, addmsg);
}

int send_msg(int fd, struct tparam *th, char *header_msg)
{
	int n;
	int header_len, msg_len, footer_len, total_len;
	int buffer_len;
	char contentlen[30];
	char *buffer;

	header_len = strlen(http_header1);
	msg_len    = strlen(th->send_buf);
	footer_len = strlen(http_footer);

	total_len  = header_len + msg_len + footer_len;

	/* make Content-Length */
	sprintf(contentlen,
		"Content-Length: %d\r\n\r\n", total_len);

	/* memory allocate */
	buffer = (char*)malloc(total_len + 1);
	*buffer = '\0';

	DPRINTF(0, ("send_msg: length = %d\r\n\r\n",
		header_len + msg_len + footer_len));

	/* copy control header */
	strcat(buffer, header_msg);
	strcat(buffer, http_contype);
	strcat(buffer, contentlen);

	/* copy html header */
	strcat(buffer, http_header1);

	/* copy message */
	strcat(buffer, th->send_buf);

	/* copy footer */
	strcat(buffer, http_footer);

	buffer_len = strlen(buffer);

	DPRINTF(0, ("SEND_DATA:(%d)byte\n%s\n", buffer_len, buffer));

	if (write(fd, buffer, buffer_len) != buffer_len){
		printf("error: writing %d chars\n", buffer_len);
	}

	/* clear buffer */
	strcpy(th->send_buf, "\0");

	/* free buffer */
	free(buffer);

	return buffer_len;
}

void print_command_page(struct tparam *th2)
{
	char str[C_NAME];
	int i;

	send_buf(th2,
	   "<form action=\"/cmd\" method=\"post\">");
	
	send_buf(th2, "Channel:");
	send_buf(th2, "<br><select name=\"cname\">");
	send_buf(th2, "<option value=\"\">specific</option>");
	for (i = 0; i < th2->ch_count + 1; i++) {
		sprintf(str, "<option value=\"%s\">%s</option>",
			th2->name[i], th2->name[i]);
		send_buf(th2, str);
	}
	send_buf(th2, "</select>");

	send_buf(th2,
	   "<br>"
	   "<input type=\"text\" name=\"cname2\" size=\"17\">"
	   "<br>"
	   "<input type=\"radio\" name=\"cmd\" value=\"part\">PART"
	   "<input type=\"radio\" name=\"cmd\" value=\"join\" CHECKED>JOIN"
	   "<hr>"
	   "<input type=\"radio\" name=\"cmd\" value=\"topic\">TOPIC"
	   "<input type=\"radio\" name=\"cmd\" value=\"nick\">NICK"
	   "<br>"
	   "<input type=\"text\" name=\"topic\" size=\"17\">");

	send_buf(th2, "<hr>Show Topic");

	if (th2->show_topic) {
	   send_buf(th2,
	      "<input type=\"radio\" name=\"t_sel\" value=\"on\" CHECKED>On"
	      "<input type=\"radio\" name=\"t_sel\" value=\"off\">Off");
	} else {
	   send_buf(th2,
	      "<input type=\"radio\" name=\"t_sel\" value=\"on\">On"
	      "<input type=\"radio\" name=\"t_sel\" value=\"off\" CHECKED>Off");
	}

	send_buf(th2,
	   "<hr><input type=\"submit\" value=\"send\">"
	   "<a accesskey=\"8\" href=\"/\"> back[8]</a></form>");

	if (th2->auth_method == 2) { /* Easy Access */
		send_buf(th2,
			"<hr><a href=\"logout\">logout</a><br>");
		send_buf(th2,
			"<hr><a href=\"logoff\">logoff</a><br>");
	}
}

int send_join(struct tparam *th, char *channel)
{
	int i;
	char channel2[C_NAME];

	/* any ->%hoge */
	channel_encode(channel2, channel);

	/* search exist channel */
	for (i = 0; i <= th->ch_count; i++) {
		if (strcmp2(th->name[i], channel2) == 0) {
			DPRINTF(0, ("channel exist!\n"));
			return (0);
		}
	}

	/* %hoge -> #hoge*.jp */
	channel_decode(channel2, channel);

	if (channel2[0] == '#') { /* make channel */
		sprintf(th->postdata, ":%s JOIN %s\r\n",
			th->real_nickname, channel2);
	} else {			/* make channel with person */
		/* make new channel */
		channel_make(th, channel2);
	}

	return (0);

}

int send_part(struct tparam *th, char *channel)
{
	char channel2[C_NAME];

	/* any -> #hoge*.jp */
	channel_decode(channel2, channel);

	if (channel2[0] == '#') {	/* disconnect from irc-channel */
		sprintf(th->postdata, ":%s PART %s\r\n",
			th->real_nickname, channel2);
	} else {			/* disconnect from person */
		/* delete channel */
		channel_delete(th, channel2);
	}

	return (0);
}
