/* $Id: decode.c,v 1.31 2006/01/04 02:30:47 ichiro Exp $ */
/*
 * Copyright (c) 2004, 2005, 2006
 *	Ichiro FUKUHARA <ichiro@ichiro.org>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Ichiro FUKUHARA.
 * 4. The name of the company nor the name of the author may be used to
 *    endorse or promote products derived from this software without specific
 *    prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ICHIRO FUKUHARA ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ICHIRO FUKUHARA OR THE VOICES IN HIS HEAD BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <errno.h>
#include <sys/types.h>
#include <regex.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <net/if.h>
#include <sys/time.h>
#include <sys/param.h>

#include "kircd.h"

#ifdef HAVE_ICONV
#include <iconv.h>
#endif

extern int debug;

int charconv(char *dst, size_t dst_len, const char *src, size_t src_len, const char *to, const char *from)
{
	iconv_t ic;
	int result = 0;
	const char *p_in;
	char *p_out;

	p_in = src;
	p_out = dst;

	DPRINTF(1, ("charconv %s -> %s\n", from, to));
	ic = iconv_open(to, from);

	if (ic == (iconv_t)(-1)) {
		printf("error: iconv_open(%s, %s)\n", to, from);
		iconv_close(ic);
		return -1;
	}

	result = iconv(ic, &p_in, &src_len, &p_out, &dst_len);
	if (result == (size_t)(-1))
		printf("error: iconv()\n");

	iconv_close(ic);

	return result;
}

int url_decode_jis(char *src)
{
	int n, j;
	int len = 0;
	int count = 0;
	char *p;

	const char *q;
	size_t in_len, out_len;
	unsigned char data[IRC_MAX * 2];
	out_len = sizeof(data);

	p = src;
	bzero(data, sizeof(data));

	if (strlen(src) == 0) 
		return (1);

	/* URL convert to raw data */
	len = url_decode_rawdata(data, src);
	q = data;
	in_len = len + 1;

	/* check encode method */
	for (n = 0; n < len; n++) {
		if (data[n] == 0x1B) { /* found JIScode */
			DPRINTF(1, ("found JIS\n"));
			strcpy(p, data);
			return (0);
		}

		count = 0;
		if (data[n] >= 0xC0 && data[n] <= 0xF7) {
			if (data[n] >= 0xC0 &&
			    data[n] <= 0xDF) { /* UCS-2 */
				count = 1;
			} else if(data[n] >= 0xE0 &&
				  data[n] <= 0xEF) { /* UCS-3 */
				count = 2;
			} else if(data[n] >= 0xF0 &&
				  data[n] <= 0xF7) { /* UCS-4*/
				count = 3;
			}
			for (j = 0; j < count; j++) {
				if (data[n+1] < 0x80 ||
				    data[n+1] > 0xBF)
					goto OUT; /* not UTF-8 */
			}
			DPRINTF(1, ("found UTF-8\n"));
			charconv(p, out_len, q, in_len, "iso-2022-jp", "utf-8");
			return (0);
		}
OUT:

		if (data[n] < 0x80) { 
			goto loop_end;
		} else if (data[n] >= 0x81 && data[n] <= 0x9F) {
			DPRINTF(1, ("found SJIS\n"));
			charconv(p, out_len, q, in_len, "iso-2022-jp", "sjis");
			return (0);
		} else if (data[n] >= 0xA1 && data[n] <= 0xDF) {
			if ((data[n+1] < 0x80) ||
			    (data[n+1] > 0x80 && data[n+1] < 0xA0)) {
				DPRINTF(1, ("found SJIS+kana\n"));
				charconv(p, out_len, q, in_len, "iso-2022-jp", "sjis");
				return (0);
			}
		}

		if (data[n] >= 0xF0 && data[n] <= 0xFE) {
			DPRINTF(1, ("found EUC\n"));
			charconv(p, out_len, q, in_len, "iso-2022-jp", "euc-jp");
			return (0);
		} else { 
			n++;
		}

		if ((data[n] >= 0x40 && data[n] <= 0x7E) || 
		    (data[n] >= 0x80 && data[n] <= 0xA0)) {
			DPRINTF(1, ("found SJIS\n"));
			charconv(p, out_len, q, in_len, "iso-2022-jp", "sjis");
			return (0);
		} else if (data[n] >= 0xFD && data[n] <= 0xFE) {
			DPRINTF(1, ("found EUC\n"));
			charconv(p, out_len, q, in_len, "iso-2022-jp", "euc-jp");
			return (0);
		}
loop_end:
	;;
	}

	/* printf("use EUC conv\n"); */
	charconv(p, out_len, q, in_len, "iso-2022-jp", "euc-jp");

	return (0);
}

int decode_jis2sjis(char *src)
{
	int n, len;
	char *p;
	const char *q;
	size_t in_len, out_len;
	unsigned char data[IRC_MAX * 2];
	out_len = sizeof(data);

	strcpy(data, src);
	len = strlen(src);

	p = src;
	q = data;
	in_len = len + 1;

	/* check encode */
	for (n = 0; n < len; n++) {
		if (data[n] == 0x1B) { /* found JIScode */
			DPRINTF(1, ("decode_jis2sjis() jis2sjis conv\n"));
			charconv(p, out_len, q, in_len, "sjis", "iso-2022-jp");
			return (0);
		}
	}
	return (0);
}

int url_decode_rawdata(char *dst, char *src)
{
	int i, j, len;
	char *p, hex_buf[3];
	long hex;

	len = strlen((char *)src);
	p = dst;

	for (i = 0, j = 0; i < len; i++, j++){
		if (src[i] == '+' ){
			p[j] = ' ';
			continue;
		}
		if (src[i] == '%'){ 
			sprintf(hex_buf,"%c%c",src[i+1],src[i+2]);
			hex = strtol(hex_buf, NULL, 16);
			p[j] = (char)hex;
			i += 2;
		} else {
			p[j] = src[i];
		}
        }
        p[j] = '\0';

	return j;
}

int ltgt_encode(char *dst, char *src)
{
        int i, j, len, esc_in;
        char *p;

        len = strlen((char *)src);
	p = dst;
	esc_in = 0;

	for (i = 0, j = 0; i < len; i++) {
		/* make flag for ESC-in,out */
		if ((src[i] == 0x1B) && (src[i + 1] == 0x24) &&
		    (src[i + 2] == 0x42))
			esc_in = 1;
		else if ((src[i] == 0x1B) &&
			 (src[i + 1] == 0x28) &&
			 (src[i + 2] == 0x42))
			esc_in = 0;

		/* '<','>' ---> '&lt;','&gt;' */
		if ((esc_in == 0) && (src[i] == '<')) { 
			strcat(p, "&lt;");
			j += 4;
		} else if ((esc_in == 0) && (src[i] == '>')) {
			strcat(p, "&gt;");
			j += 4;
		} else {
			p[j] = src[i];
			j++;
		}
	}
        p[j] = '\0';

        return (0);
}

int channel_decode(char *dst, char *src)
{
	char channel[40];

	/* %hoge -> #hoge:*.jp */
	if (src[0] == '%') {
		sscanf(src, "%%%s", channel);
		sprintf(dst, "#%s:*.jp", channel);
	} else
		strcpy(dst, src);

	return (0);
}

int channel_encode(char *dst, char *src)
{
	int n = 0;
	char channel[40];
	char sufix[3];

	/* #hoge:*.jp -> %hoge */
	if ((n = sscanf(src, "#%[^:]:%*2s%2s",
			channel, sufix)) == 2)
		sprintf(dst, "%%%s", channel);
	else
		strcpy(dst, src);

	return (0);
}

const char B64[] =
	"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
#define Val(i)  ( src[i] == '=' ? 0 : strchr(B64, src[i]) - B64 )

char * base64_decode(char *src)
{
	int i, j, len;
	static char buf[IRC_MAX * 2];
	char *p;

	len = strlen(src);
	p = buf;

	for (i = 0, j = 0; i < len; i += 4){
		p[j]   = (char) ((Val(i) << 2) |
			        ((Val(i+1) & 0x30) >> 4));
		p[j+1] = (char)(((Val(i+1) & 0x0F) << 4) |
				((Val(i+2) & 0x3C) >> 2));
		p[j+2] = (char)(((Val(i+2) & 0x03) << 6) |
				 (Val(i+3) & 0x3F));
		j += 3;
	}
	p[j] = '\0';

	return p;
}

char* href_conv(char* str) {
	regex_t reg;
	regmatch_t match;
	int regsuccess; 

	char *matched_str;
	char *head_str;
	char *tail_str;

	int matched_str_len;
	int head_str_len;
	int tail_str_len;

	regcomp(&reg,"http://[[:alnum:]./~?&%#_=-]+",REG_EXTENDED);
	regsuccess = regexec(&reg, str, 1, &match, 0);
	regfree(&reg);

	if (regsuccess == REG_NOMATCH) return str;

	matched_str_len = match.rm_eo - match.rm_so;
	head_str_len = match.rm_so;
	tail_str_len = strlen(str) - match.rm_eo;

	/* match str */
	matched_str = (char*)malloc(matched_str_len + 1);
	if (matched_str == NULL) return str;
	*matched_str = '\0';
	strncat(matched_str, &str[match.rm_so], matched_str_len);

	/* head str */
	head_str = (char*)malloc(head_str_len + 1);
	if (head_str == NULL) return str;
	*head_str = '\0';
	strncat(head_str, &str[0], head_str_len);

	/* tail str */
	tail_str = (char*)malloc(tail_str_len + 1);
	if (tail_str == NULL) return str;
	*tail_str = '\0';
	strncat(tail_str, &str[match.rm_eo], tail_str_len);

	sprintf(str, "%s<a href=\"%s\">%s</a>%s",
		head_str, matched_str, matched_str, tail_str);

	/* free heap */
	free(head_str);
	free(matched_str);
	free(tail_str);

	return str;
}

int strcmp2(char *str1, char *str2)
{
	char *p, *q;

	for (p = str1, q = str2; tolower(*p) == tolower(*q); p++,q++) {
		if (*p == '\0')
			return (0);
	}
	return tolower(*p) > tolower(*q) ? (1) : (-1);
}

int count_user(char *str)
{
	char *p, *q;
	int count = 1;

	q = (char*)malloc(strlen(str) + 1);
        if (q == NULL) return -1;

	strcpy(q, str);

	p = strtok(q, " ");
	while (p != NULL ) {
		p = strtok(NULL," ");
		if (p != NULL) count++;
	}

	free(q);

	return count;
}
