/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_META_LIST_H__
#define __KZ_META_LIST_H__

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define KZ_TYPE_META_LIST		(kz_meta_list_get_type ())
#define KZ_META_LIST(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_META_LIST, KzMETAList))
#define KZ_META_LIST_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_META_LIST, KzMETAListClass))
#define KZ_IS_META_LIST(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_META_LIST))
#define KZ_IS_META_LIST_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_META_LIST))
#define KZ_META_LIST_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_META_LIST, KzMETAListClass))

typedef struct _KzMETAList KzMETAList;
typedef struct _KzMETAListClass KzMETAListClass;

struct _KzMETAList
{
	GObject parent;

	/*
	 *  list of KzMETA
	 */
	GSList *items;
};

struct _KzMETAListClass
{
	GObjectClass parent_class;

	/* -- signals -- */
	void (*updated) (KzMETAList *metalist);
};

GtkType    kz_meta_list_get_type     (void);
KzMETAList *kz_meta_list_new          (void);

/* singleton */
KzMETAList *kz_meta_list_get_instance (void);

void       kz_meta_list_set_list     (KzMETAList *metalist,
				     GSList    *new_list);
void       kz_meta_list_save         (KzMETAList *metalist);

G_END_DECLS

#endif /* __KZ_META_LIST_H__ */
