/*
 * Profile
 * copyright (c) 2002-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 *  2003-08-28 Takuro Ashie <ashie@homa.ne.jp>
 *      Translated comments into English.
 *
 *  2003-08-27 Takuro Ashie <ashie@homa.ne.jp>
 *      Modified coding style.
 *      Changed interface of profile_open().
 */

#ifndef __PROFILE_H__
#define __PROFILE_H__


/* #include "common.h" */
#include <glib.h>


G_BEGIN_DECLS

#define PROFILE_DATA_TYPE_UNKNOW 0
#define PROFILE_DATA_TYPE_SPACE 1
#define PROFILE_DATA_TYPE_COMMENT 2
#define PROFILE_DATA_TYPE_SECTION 3
#define PROFILE_DATA_TYPE_KEY 4

#define PROFILE_VALUE_TYPE_BOOL 0
#define PROFILE_VALUE_TYPE_INT 1
#define PROFILE_VALUE_TYPE_STRING 2
#define PROFILE_VALUE_TYPE_ARRAY 3


typedef struct ProfileList_Tag {
	gchar *data,*section,*key,*value;
	guint type;
	struct ProfileList_Tag *prev,*next;
} ProfileList;

typedef struct Profile_Tag {
	gboolean edit;
	gchar *file, *subfile;
	ProfileList *list, *sublist;
} Profile;


/*
 * Open the initialize file.
 * file,file name
 * RET,the Profile struct
 */
Profile *profile_open (const gchar *file, const gchar *subfile);


/*
 * Close the initialize file.
 * profile,the Profile struct
 * RET,TRUE:normal exit,FALSE:error
 */
gboolean profile_close (Profile *profile);


/*
 * Get a string from the initialize file.
 * profile,the Profile struct
 * section,name of the section
 * key,name of the key
 * RET,string,NULL:error
 */
gchar *profile_get_string (Profile *profile,
			   const gchar *section,
			   const gchar *key);


/*
 * Get size of a value.
 * profile,the Profile struct
 * section,name of the section
 * key,name of the key
 * type,value type
 * RET,bytes,0:error
 */
gint profile_get_size (Profile *profile,
		       const gchar *section,
		       const gchar *key,
		       const guint type);


/*
 * Get a value from the initialize file.
 * profile,the Profile struct
 * section,name of the section
 * key,name of the key
 * value,buffer to store value.
 * size,size of buffer to store value.
 * type,value type
 * RET,TRUE:normal exit,FALSE:error
 */
gboolean profile_get_value (Profile *profile,
			    const gchar *section,
			    const gchar *key,
			    gpointer value,
			    const gint size,
			    const guint type);


/*
 * Set a value into the initialize file.
 * profile,the Profile struct
 * section,name of the section
 * key,name of the key
 * value,buffer which store the value.
 * size,size of buffer which store the value.
 * type,value type
 * RET,TRUE:normal exit,FALSE:error
 */
gboolean profile_set_value (Profile *profile,
			    const gchar *section,
			    const gchar *key,
			    gconstpointer value,
			    const gint size,
			    const guint type);


/*
 * Delete a section from the initialize file.
 * profile,the Profile struct
 * section,name of the section
 * RET,TRUE:normal exit,FALSE:error
 */
gboolean profile_delete_section (Profile *profile,
				 const gchar *section);


/*
 * Delete a key from the initialize file.
 * profile,the Profile struct
 * section,name of the section
 * key,key
 * RET,TRUE:normal exit,FALSE:error
 */
gboolean profile_delete_key (Profile *profile,
			     const gchar *section,
			     const gchar *key);


/*
 * Enumerate sections in the initialize file.
 * profile,the Profile struct
 * RET,list of sections,NULL:error
 */
GList *profile_enum_section (Profile *profile);


/*
 * Enumelate keys in the initialize file.
 * profile,the Profile struct
 * section,name of the section
 * RET,list of keys,NULL:error
*/
GList *profile_enum_key (Profile *profile,
			 const gchar *section);


G_END_DECLS
#endif
