/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_RSS_H__
#define __KZ_RSS_H__

#include <glib-object.h>
#include <pthread.h>
#include "kz-window.h"

G_BEGIN_DECLS

#define KZ_TYPE_RSS		(kz_rss_get_type ())
#define KZ_RSS(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_RSS, KzRSS))
#define KZ_RSS_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass),  KZ_TYPE_RSS, KzRSSClass))
#define KZ_IS_RSS(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_RSS))
#define KZ_IS_RSS_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass),  KZ_TYPE_RSS))
#define KZ_RSS_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj),  KZ_TYPE_RSS, KzRSSClass))

typedef struct _KzRSS KzRSS;
typedef struct _KzRSSClass KzRSSClass;
typedef struct _KzRSSItem KzRSSItem;
typedef struct _KzRSSItems KzRSSItems;

typedef enum {
	KZ_RSS_NORMAL,
	KZ_RSS_LOADING,
} KzRSSState;

struct _KzRSS
{
	GObject parent;

	gchar *title;
	/* uri of rss/rdf  */
	gchar *uri;

	/* rss file item */
	gchar *rss_title;
	gchar *rss_link;
	gchar *rss_description;
	gchar *rss_date;

	/* update timer id */
	guint timer_id;
	/* update interval minutes */
	gint  update_interval;
	/* rss items */
	GSList *items;

	pthread_t fetch_thread;

	KzRSSState state;
};

struct _KzRSSClass
{
	GObjectClass parent_class;

	/* -- signals -- */
	void (*update_start)     (KzRSS *rss);
	void (*update_completed) (KzRSS *rss);
};

struct _KzRSSItem
{
	KzRSS *rss;

	gchar *title;
	gchar *link;
	gchar *description;
	gchar *date;
};

GType  kz_rss_get_type (void);
KzRSS *kz_rss_new      (gchar *uri,
			gchar *title,
			guint  update_interval);
void   kz_rss_start    (KzRSS *rss);

void   kz_rss_force_update(KzRSS *rss);

G_END_DECLS

#endif /* __KZ_RSS_H__ */
