/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "kz-sidebar.h"

#include <gtk/gtktreeview.h>
#include <gtk/gtktreestore.h>

#ifndef __KZ_TAB_TREE_H__
#define __KZ_TAB_TREE_H__

#define KZ_TYPE_TAB_TREE		(kz_tab_tree_get_type ())
#define KZ_TAB_TREE(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_TAB_TREE, KzTabTree))
#define KZ_TAB_TREE_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_TAB_TREE, KzTabTreeClass))
#define KZ_IS_TAB_TREE(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_TAB_TREE))
#define KZ_IS_TAB_TREE_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_TAB_TREE))
#define KZ_TAB_TREE_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_TAB_TREE, KzTabTreeClass))

typedef struct _KzTabTree	KzTabTree;
typedef struct _KzTabTreeClass	KzTabTreeClass;
typedef struct _KzTabTreePriv	KzTabTreePriv;
typedef struct _KzTabTreeItem	KzTabTreeItem;

struct _KzTabTree
{
	GtkVBox parent;

	KzSidebar    *sidebar;

	GtkTreeView  *tree_view;
	GtkTreeStore *store;

	gboolean      switching;
};

struct _KzTabTreeClass
{
	GtkVBoxClass parent_class;
};

KzSidebarEntry   *kz_tab_tree_get_entry(gint idx);

GtkType	          kz_tab_tree_get_type           (void);
GtkWidget        *kz_tab_tree_new                (KzSidebar *sidebar);

#endif /* __KZ_TAB_TREE_H__ */
