// -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*-

//
//  Copyright (C) 2002-2003 Hiroyuki Ikezoe
//  Copyright (C) 2003 Takuro Ashie
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#ifdef HAVE_CONFIG_H
#	include "config.h"
#endif
#include "mozilla.h"
#include "mozilla-prefs.h"

#include <gtkmozembed.h>


static void 
destroy_browser_cb (GtkMozEmbed *embed, GtkWidget *transient_window)
{
	gtk_widget_destroy(GTK_WIDGET(transient_window));
}


static void
new_window_orphan_cb (GtkMozEmbedSingle *embed, GtkMozEmbed **retval,
		      guint chromemask, gpointer data)
{
	// FIXME! but I don't have any nice idea...
	GtkWidget *newWindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	GtkMozEmbed *newBrowser = GTK_MOZ_EMBED(gtk_moz_embed_new());

	gtk_container_add(GTK_CONTAINER(newWindow), GTK_WIDGET(newBrowser));
	g_signal_connect(G_OBJECT(newBrowser),"destroy_browser",
			 G_CALLBACK(destroy_browser_cb),newWindow);
	*retval = GTK_MOZ_EMBED(newBrowser);
}


extern "C" void
mozilla_init (void)
{
	GtkMozEmbedSingle *single = NULL;

	mozilla_prefs_init();

	gtk_moz_embed_push_startup();

	mozilla_prefs_set();

	//
	// get the singleton object and hook up to its new window callback
	// so we can create orphaned windows.
	//
	single = gtk_moz_embed_single_get();
	if (!single) {
		g_error("Failed to get singleton embed object!");
		return;
	}

	g_signal_connect(G_OBJECT(single), "new_window_orphan",
			 G_CALLBACK(new_window_orphan_cb), NULL);
}


extern "C" void
mozilla_exit (void)
{
	gtk_moz_embed_pop_startup();
}
