/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2002 Hiroyuki Ikezoe
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_MOZ_EMBED_H__
#define __KZ_MOZ_EMBED_H__

#include <gtk/gtk.h>
#include <gtkmozembed.h>

G_BEGIN_DECLS

#define KZ_TYPE_MOZ_EMBED		(kz_moz_embed_get_type ())
#define KZ_MOZ_EMBED(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_MOZ_EMBED, KzMozEmbed))
#define KZ_MOZ_EMBED_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_MOZ_EMBED, KzMozEmbedClass))
#define KZ_IS_MOZ_EMBED(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_MOZ_EMBED))
#define KZ_IS_MOZ_EMBED_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_MOZ_EMBED))
#define KZ_MOZ_EMBED_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_MOZ_EMBED, KzMozEmbedClass))

typedef struct _KzMozEmbed	KzMozEmbed;
typedef struct _KzMozEmbedClass	KzMozEmbedClass;
typedef struct _KzMozEmbedPriv	KzMozEmbedPriv;

struct _KzMozEmbed
{
	/* embedding widget */
	GtkMozEmbed parent;

	/* image popup window */
	GtkWidget *popup_window;
	
	/* location and title */
	gchar *location;
	gchar *title;

	gint load_started; /* count of currently active connections */
	gint load_percent;
	gint bytes_loaded;
	gint max_bytes_loaded;
	gboolean  is_loading;
	const gchar *load_status_message;

	KzMozEmbedPriv *priv;
};

struct _KzMozEmbedClass
{
	GtkMozEmbedClass parent_class;
};


/**
 * MozillaKeyModifier: key modifiers
 */
typedef enum
{
	ALT_KEY   = (1 << 0),
	CTRL_KEY  = (1 << 1),
	SHIFT_KEY = (1 << 2),
	META_KEY  = (1 << 3),
	KEY_CODE  = (1 << 4)
} MozillaKeyModifier;

#define CONTEXT_NONE     0
#define CONTEXT_DEFAULT  1
#define CONTEXT_LINK     2
#define CONTEXT_IMAGE    4
#define CONTEXT_DOCUMENT 8
#define CONTEXT_INPUT    64
#define CONTEXT_OTHER    128
#define CONTEXT_XUL      256


typedef enum
{
	MOZILLA_EVENT_KEY,
	MOZILLA_EVENT_MOUSE
} KzMozEventType;

typedef struct
{
	KzMozEventType type;

	gchar *link;
	gchar *linktext;
	gchar *img;

	/*
	gboolean framed_page;
	gint context;
	*/
} KzMozEvent;

typedef struct
{
	KzMozEvent cinfo;
	gint key;
	gint modifier;
	gint char_code;
} KzMozEventKey;

typedef struct
{
	KzMozEvent cinfo;
	gint button;
	gint modifier;
	gint x, y;

	/* guint timestamp; */
} KzMozEventMouse;


GtkType      kz_moz_embed_get_type         (void);
GtkWidget   *kz_moz_embed_new              (const gchar *url);

void         kz_moz_embed_load_url         (KzMozEmbed  *kzembed,
					    const gchar *url);
#define      kz_moz_embed_is_loading(embed) \
                 (KZ_IS_MOZ_EMBED(embed) ? KZ_MOZ_EMBED(embed)->is_loading : FALSE)

const gchar *kz_moz_embed_get_title        (KzMozEmbed  *kzembed);
const gchar *kz_moz_embed_get_location     (KzMozEmbed  *kzembed);
gchar       *kz_moz_embed_ensure_title     (KzMozEmbed  *kzembed);
gchar       *kz_moz_embed_get_link_message (KzMozEmbed  *kzembed);

gboolean     kz_moz_embed_can_cut_selection  (KzMozEmbed  *kzembed);
gboolean     kz_moz_embed_can_copy_selection (KzMozEmbed  *kzembed);
gboolean     kz_moz_embed_can_paste          (KzMozEmbed  *kzembed);
void         kz_moz_embed_cut_selection      (KzMozEmbed  *kzembed);
void         kz_moz_embed_copy_selection     (KzMozEmbed  *kzembed);
void         kz_moz_embed_paste              (KzMozEmbed  *kzembed);
void         kz_moz_embed_select_all         (KzMozEmbed  *kzembed);

gboolean     kz_moz_embed_find               (KzMozEmbed  *embed,
					      const char  *keyword);

gboolean     kz_moz_embed_selection_is_collapsed (KzMozEmbed *kzembed);

gboolean     kz_moz_embed_get_links          (KzMozEmbed  *kzembed,
					      GList      **list,
					      gboolean     selected_only);

#if 1 /* FIXME!!!!! */
glong     kz_moz_embed_get_key_event_info   (KzMozEmbed     *kzembed,
					     gpointer        event,
					     KzMozEventKey **info);
glong     kz_moz_embed_get_mouse_event_info (KzMozEmbed     *kzembed,
					     gpointer        event,
					     KzMozEventMouse **info);
KzMozEvent *
          kz_moz_embed_event_new            (KzMozEventType type);
void      kz_moz_embed_event_free           (KzMozEvent    *cinfo);
#endif

G_END_DECLS

#endif /* __KZ_MOZ_EMBED_H__ */
