/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_LINKS_DIALOG_H__
#define __KZ_LINKS_DIALOG_H__

#include <gtk/gtk.h>

#include "kz-window.h"
#include "kz-mozembed.h"

G_BEGIN_DECLS

#define KZ_TYPE_LINKS_DIALOG		(kz_links_dialog_get_type ())
#define KZ_LINKS_DIALOG(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_LINKS_DIALOG, KzLinksDialog))
#define KZ_LINKS_DIALOG_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_LINKS_DIALOG, KzLinksDialogClass))
#define KZ_IS_LINKS_DIALOG(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_LINKS_DIALOG))
#define KZ_IS_LINKS_DIALOG_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_LINKS_DIALOG))
#define KZ_LINKS_DIALOG_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_LINKS_DIALOG, KzLinksDialogClass))

typedef struct _KzLinksDialog           KzLinksDialog;
typedef struct _KzLinksDialogClass      KzLinksDialogClass;


struct _KzLinksDialog
{
	GtkDialog parent;

	KzWindow     *kz;
	KzMozEmbed   *kzembed;

	GtkWidget    *scrolled_window;
	GtkTreeView  *tree_view;
	GtkListStore *list_store;
};

struct _KzLinksDialogClass
{
	GtkDialogClass parent_class;
};

GtkType          kz_links_dialog_get_type          (void);
GtkWidget       *kz_links_dialog_new               (KzWindow   *kz,
						    KzMozEmbed *kzembed);

#endif /* __KZ_LINKS_DIALOG_H__ */
