/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "kz-link.h"


static void kz_link_finalize (KzLink *kzlink);


KzLink *
kz_link_new (void)
{
	KzLink *kzlink = g_new0(KzLink, 1);
	kzlink->title     = NULL;
	kzlink->url       = NULL;
	kzlink->ref_count = 1;

	return kzlink;
}


KzLink *
kz_link_ref (KzLink *kzlink)
{
	g_return_val_if_fail(kzlink, NULL);

	kzlink->ref_count++;

	return kzlink;
}


void
kz_link_unref (KzLink *kzlink)
{
	g_return_if_fail(kzlink);

	kzlink->ref_count--;

	if (kzlink->ref_count < 1)
		kz_link_finalize(kzlink);
}


static void
kz_link_finalize (KzLink *kzlink)
{
	g_return_if_fail(kzlink);

	g_free(kzlink->title);
	g_free(kzlink->url);
	g_free(kzlink);
}

