/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 *  2003-12-17 Hiroyuki Ikezoe <poincare@ikezoe.net>
 *   these codes picked from EphyEventListner.cpp in epiphany-1.0.6.    
 */

#include "kz-mozeventlistener.h"

#include <nsCOMPtr.h>
#include <nsIDOMNode.h>
#include <nsIDOMElement.h>
#include <nsString.h>
#include <nsIDOMDocument.h>
#include <nsIURI.h>
#include <nsIDocument.h>
#include <nsIDOMEventTarget.h>
#include <nsIDOMEvent.h>

#include "kz-favicon.h"

KzMozEventListener::KzMozEventListener(void)
{
	NS_INIT_ISUPPORTS();
	mOwner = nsnull;
}

KzMozEventListener::~KzMozEventListener()
{
}

NS_IMPL_ISUPPORTS1(KzMozEventListener, nsIDOMEventListener)

nsresult
KzMozEventListener::Init(KzMozEmbed *aOwner)
{
	mOwner = aOwner;
	return NS_OK;
}

nsresult
KzMozEventListener::HandleLink (nsIDOMNode *node)
{
	nsresult result;

	nsCOMPtr<nsIDOMElement> linkElement;
	linkElement = do_QueryInterface (node);
	if (!linkElement) return NS_ERROR_FAILURE;

	nsAutoString name;
	result = linkElement->GetAttribute (NS_LITERAL_STRING("rel"), name);
	if (NS_FAILED(result)) return NS_ERROR_FAILURE;

	nsAutoString link;
	result = linkElement->GetAttribute (NS_LITERAL_STRING("href"), link);
	if (NS_FAILED (result) || link.IsEmpty()) return NS_ERROR_FAILURE;

	nsCOMPtr<nsIDOMDocument> domDoc;
	result = node->GetOwnerDocument(getter_AddRefs(domDoc));
	if (NS_FAILED(result) || !domDoc) return NS_ERROR_FAILURE;

	nsCOMPtr<nsIDocument> doc = do_QueryInterface (domDoc);
	if(!doc) return NS_ERROR_FAILURE;

#if MOZILLA_SNAPSHOT > 12
	nsIURI *nsURI;
	nsURI = doc->GetDocumentURI ();
	if (nsURI == NULL) return NS_ERROR_FAILURE;
#else
	nsIURI *nsURI;
	nsURI = doc->GetDocumentURL ();
	if (nsURI == NULL) return NS_ERROR_FAILURE;
#endif

	const nsACString &linkstring = NS_ConvertUCS2toUTF8(link);
	nsCAutoString url;
	result = nsURI->Resolve (linkstring, url);
	if (NS_FAILED (result)) return NS_ERROR_FAILURE;

	if (name.EqualsIgnoreCase("SHORTCUT ICON") ||
	    name.EqualsIgnoreCase("ICON"))
	{
		KzFavicon *kzfav = kz_favicon_get_instance();
		char *favicon_uri = g_strdup (url.get());
		const char *document_uri = kz_embed_get_location(KZ_EMBED(mOwner));
		kz_favicon_get_icon_from_uri(kzfav, favicon_uri, document_uri);
		g_free (favicon_uri);
		g_object_unref(kzfav);
	}
	else //if (link.EqualsIgnoreCase("ALTERNATE"))
	{
		kz_embed_set_nav_link(KZ_EMBED(mOwner),
				      NS_ConvertUCS2toUTF8(name).get(),
				      NS_ConvertUCS2toUTF8(link).get());
	}
		
	return NS_OK;
}	

NS_IMETHODIMP
KzMozEventListener::HandleEvent(nsIDOMEvent* aDOMEvent)
{
	nsCOMPtr<nsIDOMEventTarget> eventTarget;
	
	aDOMEvent->GetTarget(getter_AddRefs(eventTarget));

	nsresult result;
	nsCOMPtr<nsIDOMNode> node = do_QueryInterface(eventTarget, &result);
	if (NS_FAILED(result) || !node) return NS_ERROR_FAILURE;

	HandleLink (node);

	return NS_OK;
}
