/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003-2004 Hiroyuki Ikezoe
 *  Copyright (C) 2003-2004 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copyED of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include "kazehakase.h"
#include "kz-embed-event.h"

#ifndef __KZ_EMBED_H__
#define __KZ_EMBED_H__

G_BEGIN_DECLS

#define KZ_TYPE_EMBED		(kz_embed_get_type())
#define KZ_EMBED(o)		(G_TYPE_CHECK_INSTANCE_CAST((o), KZ_TYPE_EMBED, KzEmbed))
#define KZ_IS_EMBED(o)		(G_TYPE_CHECK_INSTANCE_TYPE((o), KZ_TYPE_EMBED))
#define KZ_EMBED_GET_IFACE(o)	(G_TYPE_INSTANCE_GET_INTERFACE((o), KZ_TYPE_EMBED, KzEmbedIFace))

typedef struct _KzEmbed      KzEmbed;
typedef struct _KzEmbedIFace KzEmbedIFace;

typedef enum {
	KZ_EMBED_NORMAL_FLAG = 0,
	KZ_EMBED_SOURCE_FLAG = 1 << 0
} KzEmbedLoadFlag;

typedef enum {
	KZ_EMBED_RELOAD_NORMAL                 = 0,
	KZ_EMBED_RELOAD_BYPASS_CACHE           = 1,
	KZ_EMBED_RELOAD_BYPASS_PROXY           = 2,
	KZ_EMBED_RELOAD_BYPASS_PROXY_AND_CACHE = 3,
	KZ_EMBED_RELOAD_CHARSET_CHANGE         = 4
} KzEmbedReloadFlag;

typedef enum {
	KZ_EMBED_GO_NONE,
	KZ_EMBED_GO_BACK,
	KZ_EMBED_GO_FORWARD,
	KZ_EMBED_GO_UP,
	KZ_EMBED_GO_INDEX,
	KZ_EMBED_GO_CONTENTS,
	KZ_EMBED_GO_START,
	KZ_EMBED_GO_PREV,
	KZ_EMBED_GO_NEXT
} KzEmbedGoAction;

typedef enum {
	KZ_EMBED_LINK_NEXT,
	KZ_EMBED_LINK_PREV,
	KZ_EMBED_LINK_INDEX,
	KZ_EMBED_LINK_CONTENTS,
	KZ_EMBED_LINK_START,
	KZ_EMBED_LINK_RSS
} KzEmbedNavLink;

struct _KzEmbedIFace {
	GTypeInterface g_iface;

	/* vtable */
	void		(*load_url)		(KzEmbed       *kzembed,
						 const gchar   *url);
	void		(*view_source)		(KzEmbed       *kzembed,
						 const gchar   *url);

	gboolean	(*is_loading)		(KzEmbed       *kzembed);

	const gchar    *(*get_title)		(KzEmbed       *kzembed);
	const gchar    *(*get_location)		(KzEmbed       *kzembed);
	gchar	       *(*ensure_title)		(KzEmbed       *kzembed);
	gchar	       *(*get_link_message)	(KzEmbed       *kzembed);

	gdouble		(*get_progress)		(KzEmbed       *kzembed);

	gboolean	(*can_cut_selection)	(KzEmbed       *kzembed);
	gboolean	(*can_copy_selection)	(KzEmbed       *kzembed);
	gboolean	(*can_paste)		(KzEmbed       *kzembed);
	void		(*cut_selection)	(KzEmbed       *kzembed);
	void		(*copy_selection)	(KzEmbed       *kzembed);
	void		(*paste)		(KzEmbed       *kzembed);
	void		(*select_all)		(KzEmbed       *kzembed);

	gchar	       *(*get_selection_string)	(KzEmbed       *kzembed);

	gboolean	(*find)			(KzEmbed       *kzembed,
						 const char    *keyword,
						 gboolean	backward);
	gboolean	(*incremental_search)	(KzEmbed       *kzembed,
						 const char    *keyword,
						 gboolean	backward);

	gboolean	(*selection_is_collapsed)
						(KzEmbed       *kzembed);
	
	gboolean	(*get_links)		(KzEmbed       *kzembed,
						 GList	      **list,
						 gboolean	selected_only);

	void		(*copy_page)		(KzEmbed       *kzembed,
						 KzEmbed       *dkzembed);

	gboolean	(*shistory_copy)	(KzEmbed       *source,
						 KzEmbed       *dest,
						 gboolean	back_history,
						 gboolean	forward_history,
						 gboolean	set_current);
	gboolean	(*shistory_get_pos)	(KzEmbed       *kzembed,
						 gint	       *pos,
						 gint	       *count);
	void		(*shistory_get_nth)	(KzEmbed       *kzembed, 
						 gint		nth,
						 gboolean	is_relative,
						 gchar	      **aUrl,
						 gchar	      **aTitle);

	void		(*reload)		(KzEmbed       *kzembed,
						 gint32		flags);
	void		(*stop_load)		(KzEmbed       *kzembed);
	void		(*go_back)		(KzEmbed       *kzembed);
	void		(*go_forward)		(KzEmbed       *kzembed);
	void		(*go_up)		(KzEmbed       *kzembed);

	gboolean	(*can_go_back)		(KzEmbed       *kzembed);
	gboolean	(*can_go_forward)	(KzEmbed       *kzembed);
	gboolean	(*can_go_up)		(KzEmbed       *kzembed);

	gboolean	(*can_go_nav_link)	(KzEmbed       *kzembed,
						 KzEmbedNavLink	link);
	void		(*go_nav_link)		(KzEmbed       *kzembed,
						 KzEmbedNavLink	link);
	void		(*set_nav_link)		(KzEmbed       *kzembed,
						 const gchar   *name,
						 const gchar   *link);
	void		(*go_history_index)	(KzEmbed       *kzembed,
						 gint		index);

	void		(*do_command)		(KzEmbed       *kzembed,
						 const char    *command);
	gboolean	(*can_do_command)	(KzEmbed       *kzembed,
						 const char    *command);

	gboolean	(*get_lock)		(KzEmbed       *kzembed);
	void		(*set_lock)		(KzEmbed       *kzembed,
						 gboolean	lock);

	gchar	       *(*get_body_text)	(KzEmbed       *kzembed);
#if 0
	gchar	       *(*get_selection_source)	(KzEmbed       *kzembed);
#endif
	void		(*set_encoding)		(KzEmbed       *kzembed,
						 const char    *encoding);
	void		(*get_encoding)		(KzEmbed       *kzembed,
						 char	      **encoding,
						 gboolean      *forced);
	void		(*print)		(KzEmbed       *kzembed);
	void		(*print_preview)	(KzEmbed       *kzembed);
	void		(*create_thumbnail)	(KzEmbed       *kzembed);


	gboolean	(*save_with_content)	(KzEmbed       *kzembed,
						 const char    *rawfilename);

	gboolean	(*set_text_into_textarea)
						(KzEmbed       *kzembed,
						 gpointer	element,
						 const gchar   *text);
	gchar	       *(*get_text_from_textarea)
						(KzEmbed       *kzembed,
						 gpointer	element);


	void		(*zoom_set)		(KzEmbed       *kzembed, 
						 gint		zoom, 
						 gboolean	reflow);
	gint		(*zoom_get)		(KzEmbed       *kzembed);
	void		(*set_text_size)	(KzEmbed       *kzembed, 
						 gint		zoom, 
						 gboolean	reflow);
	gint		(*get_text_size)	(KzEmbed       *kzembed);

	gchar	       *(*get_html_with_contents)
						(KzEmbed       *kzembed,
						 const gchar   *storedir);

	void		(*set_history)		(KzEmbed       *kzembed,
						 KzBookmark    *history);
	void		(*get_history)		(KzEmbed       *kzembed,
						 KzBookmark    *history);
	guint		(*get_last_modified)	(KzEmbed       *kzembed);

#if 0
	void		(*set_edit_mode)	(KzEmbed       *kzembed);
	void		(*set_view_mode)	(KzEmbed       *kzembed);
#endif
	void            (*fine_scroll)          (KzEmbed       *embed,
						 int            horiz,
						 int            vert);
	void		(*page_down)		(KzEmbed       *kzembed);
	void		(*page_up)		(KzEmbed       *kzembed);

	/* signals */
	void     (*link_message)        (KzEmbed      *embed);
	void     (*js_status)           (KzEmbed      *embed);
	void     (*location)            (KzEmbed      *embed);
	void     (*title)               (KzEmbed      *embed);
	void     (*progress)            (KzEmbed      *embed);
	void     (*net_start)           (KzEmbed      *embed);
	void     (*net_stop)            (KzEmbed      *embed);
	void     (*new_window)          (KzEmbed      *embed,
					 KzEmbed     **new_embed);
	gint     (*open_uri)            (KzEmbed      *embed,
					 const char   *uri);
	void     (*size_to)             (KzEmbed      *embed,
					 gint          width,
					 gint          height);
	gint     (*dom_key_down)        (KzEmbed      *embed,
					 KzEmbedEvent *event);
	gint     (*dom_key_press)       (KzEmbed      *embed,
					 KzEmbedEvent  event);
	gint     (*dom_key_up)          (KzEmbed      *embed,
					 KzEmbedEvent  event);
	gint     (*dom_mouse_down)      (KzEmbed      *embed,
					 KzEmbedEvent  event);
	gint     (*dom_mouse_up)        (KzEmbed      *embed,
					 KzEmbedEvent  event);
	gint     (*dom_mouse_click)     (KzEmbed      *embed,
					 KzEmbedEvent  event);
	gint     (*dom_mouse_dbl_click) (KzEmbed      *embed,
					 KzEmbedEvent  event);
	gint     (*dom_mouse_over)      (KzEmbed      *embed,
					 KzEmbedEvent  event);
	gint     (*dom_mouse_out)       (KzEmbed      *embed,
					 KzEmbedEvent  event);
#if 1 /* not implemented yet */
	void     (*security_change)     (KzEmbed      *embed,
					 gpointer      request,
					 guint         state);
	void     (*status_change)       (KzEmbed      *embed,
					 gpointer      request,
					 gint          status,
					 gpointer      message);
#endif
};

GType		kz_embed_get_type		(void) G_GNUC_CONST;

void		kz_embed_load_url		(KzEmbed       *kzembed,
						 const gchar   *url);
void		kz_embed_view_source		(KzEmbed       *kzembed,
						 const gchar   *url);

gboolean	kz_embed_is_loading		(KzEmbed       *kzembed);

const gchar    *kz_embed_get_title		(KzEmbed       *kzembed);
const gchar    *kz_embed_get_location		(KzEmbed       *kzembed);
gchar	       *kz_embed_ensure_title		(KzEmbed       *kzembed);
gchar	       *kz_embed_get_link_message	(KzEmbed       *kzembed);

gdouble		kz_embed_get_progress		(KzEmbed       *kzembed);

gboolean	kz_embed_can_cut_selection	(KzEmbed       *kzembed);
gboolean	kz_embed_can_copy_selection	(KzEmbed       *kzembed);
gboolean	kz_embed_can_paste		(KzEmbed       *kzembed);
void		kz_embed_cut_selection		(KzEmbed       *kzembed);
void		kz_embed_copy_selection		(KzEmbed       *kzembed);
void		kz_embed_paste			(KzEmbed       *kzembed);
void		kz_embed_select_all		(KzEmbed       *kzembed);

gchar	       *kz_embed_get_selection_string
						(KzEmbed       *kzembed);

gboolean	kz_embed_find			(KzEmbed       *kzembed,
						 const char    *keyword,
						 gboolean	backward);
gboolean	kz_embed_incremental_search	(KzEmbed       *kzembed,
						 const char    *keyword,
						 gboolean	backward);

gboolean	kz_embed_selection_is_collapsed
						(KzEmbed       *kzembed);

gboolean	kz_embed_get_links		(KzEmbed       *kzembed,
						 GList	      **list,
						 gboolean	selected_only);

void		kz_embed_copy_page		(KzEmbed       *kzembed,
						 KzEmbed       *dkzembed);

gboolean	kz_embed_shistory_copy		(KzEmbed       *source,
						 KzEmbed       *dest,
						 gboolean	back_history,
						 gboolean	forward_history,
						 gboolean	set_current);
gboolean	kz_embed_shistory_get_pos	(KzEmbed       *kzembed,
						 gint	       *pos,
						 gint	       *count);
void		kz_embed_shistory_get_nth	(KzEmbed       *kzembed, 
						 gint		nth,
						 gboolean	is_relative,
						 gchar	      **aUrl,
						 gchar	      **aTitle);

void		kz_embed_reload			(KzEmbed       *kzembed,
						 KzEmbedReloadFlag flags);
void		kz_embed_stop_load		(KzEmbed       *kzembed);
void		kz_embed_go_back		(KzEmbed       *kzembed);
void		kz_embed_go_forward		(KzEmbed       *kzembed);
void		kz_embed_go_up			(KzEmbed       *kzembed);

gboolean	kz_embed_can_go_back		(KzEmbed       *kzembed);
gboolean	kz_embed_can_go_forward		(KzEmbed       *kzembed);
gboolean	kz_embed_can_go_up		(KzEmbed       *kzembed);

gboolean	kz_embed_can_go_nav_link	(KzEmbed       *kzembed,
						 KzEmbedNavLink	link);
void		kz_embed_go_nav_link		(KzEmbed       *kzembed,
						 KzEmbedNavLink	link);
void		kz_embed_set_nav_link		(KzEmbed       *kzembed,
						 const gchar   *name,
						 const gchar   *link);
void		kz_embed_go_history_index	(KzEmbed       *kzembed,
						 gint		index);

void		kz_embed_do_command		(KzEmbed       *kzembed,
						 const char    *command);
gboolean	kz_embed_can_do_command		(KzEmbed       *kzembed,
						 const char    *command);

gboolean	kz_embed_get_lock		(KzEmbed       *kzembed);
void		kz_embed_set_lock		(KzEmbed       *kzembed,
						 gboolean	lock);

gchar	       *kz_embed_get_body_text		(KzEmbed       *kzembed);
#if 0
gchar	       *kz_embed_get_selection_source	(KzEmbed       *kzembed);
#endif
void		kz_embed_set_encoding		(KzEmbed       *kzembed,
						 const char    *encoding);
void		kz_embed_get_encoding		(KzEmbed       *kzembed,
						 char	      **encoding,
						 gboolean      *forced);
void		kz_embed_print			(KzEmbed       *kzembed);
void		kz_embed_print_preview		(KzEmbed       *kzembed);
void		kz_embed_create_thumbnail	(KzEmbed       *kzembed);


gboolean	kz_embed_save_with_content	(KzEmbed       *kzembed,
						 const char    *rawfilename);

gboolean	kz_embed_set_text_into_textarea	(KzEmbed       *kzembed,
						 gpointer	element,
						 const gchar   *text);
gchar	       *kz_embed_get_text_from_textarea	(KzEmbed       *kzembed,
						 gpointer	element);


void		kz_embed_zoom_set		(KzEmbed       *kzembed, 
						 gint		zoom, 
						 gboolean	reflow);
gint		kz_embed_zoom_get		(KzEmbed       *kzembed);
void		kz_embed_set_text_size		(KzEmbed       *kzembed, 
						 gint		zoom, 
						 gboolean	reflow);
gint		kz_embed_get_text_size		(KzEmbed       *kzembed);

gchar	       *kz_embed_get_html_with_contents
						(KzEmbed       *kzembed,
						 const gchar   *storedir);

void		kz_embed_set_history		(KzEmbed       *kzembed,
						 KzBookmark    *history);
void		kz_embed_get_history		(KzEmbed       *kzembed,
						 KzBookmark    *history);

guint		kz_embed_get_last_modified	(KzEmbed       *kzembed);	


#if 0
void		kz_embed_set_edit_mode		(KzEmbed       *kzembed);
void		kz_embed_set_view_mode		(KzEmbed       *kzembed);
#endif
void            kz_embed_fine_scroll            (KzEmbed       *kzembed,
						 int            horiz,
						 int            vert);
void		kz_embed_page_up		(KzEmbed       *kzembed);	
void		kz_embed_page_down		(KzEmbed       *kzembed);	

G_END_DECLS

#endif /* __KZ_EMBED_H__ */
