/*
 * Decompiled with CFR 0.152.
 */
package com.jyugem.secs;

import com.jyugem.secs.SECSException;
import com.jyugem.secs.SECSItem;
import com.jyugem.secs.SECSList;
import com.jyugem.secs.SECSMessage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.tree.MutableTreeNode;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlMessage
extends TreeMap {
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String CREATE_ENTITY_REF_NODES = "http://apache.org/xml/features/dom/create-entity-ref-nodes";
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_NAMESPACE_PREFIXES = false;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = true;
    protected static final boolean DEFAULT_CREATE_ENTITY_REF_NODES = false;
    DOMParser parser = new DOMParser();
    Document xmldoc;

    public XmlMessage() {
        super(new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                int n2 = SECSMessage.toStreamNumber((String)object);
                if (n2 == (n = SECSMessage.toStreamNumber((String)object2))) {
                    return ((String)object).compareTo((String)object2);
                }
                return n2 - n;
            }
        });
    }

    public int open(String string) {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        try {
            this.parser.setFeature(NAMESPACES_FEATURE_ID, bl);
            this.parser.setFeature(VALIDATION_FEATURE_ID, bl2);
            this.parser.setFeature(SCHEMA_VALIDATION_FEATURE_ID, bl3);
            this.parser.setFeature(CREATE_ENTITY_REF_NODES, bl4);
        }
        catch (SAXException sAXException) {
            System.err.println("warning: Parser does not support feature");
        }
        try {
            this.parser.parse(string);
            Document document = this.parser.getDocument();
            this.setDocument(document);
            this.buildTree();
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (Exception exception) {
            System.err.println("error: Parse error occurred - " + exception.getMessage());
            Exception exception2 = exception;
            if (exception instanceof SAXException) {
                exception2 = ((SAXException)exception).getException();
            }
            if (exception2 != null) {
                exception2.printStackTrace(System.err);
            }
            exception.printStackTrace(System.err);
        }
        return 0;
    }

    public synchronized void setDocument(Document document) {
        this.xmldoc = document;
    }

    public Document getDocument() {
        return this.xmldoc;
    }

    private void buildTree() {
        if (this.xmldoc == null) {
            return;
        }
        NodeList nodeList = this.xmldoc.getChildNodes();
        int n = nodeList != null ? nodeList.getLength() : 0;
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals("secs:messages")) continue;
            this.insertMessageElementNode(node);
        }
    }

    private void insertMessageElementNode(Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList != null ? nodeList.getLength() : 0;
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || !node2.getNodeName().equals("secs:message")) continue;
            String string = null;
            NamedNodeMap namedNodeMap = node2.getAttributes();
            int n2 = namedNodeMap != null ? namedNodeMap.getLength() : 0;
            for (int j = 0; j < n2; ++j) {
                Node node3 = namedNodeMap.item(j);
                if (node3.getNodeName().equals("sf")) {
                    if (string != null) continue;
                    string = node3.getNodeValue();
                    continue;
                }
                if (!node3.getNodeName().equals("name")) continue;
                string = node3.getNodeValue();
            }
            if (string == null) {
                string = "------";
            }
            this.put(string, node2);
        }
    }

    public static SECSMessage parseMessageElementNode(Node node) throws SECSException {
        boolean bl;
        String string = null;
        String string2 = "";
        String string3 = "";
        NamedNodeMap namedNodeMap = node.getAttributes();
        boolean bl2 = namedNodeMap != null ? namedNodeMap.getLength() : 0;
        for (bl = false; bl < bl2; bl += 1) {
            Node node2 = namedNodeMap.item(bl ? 1 : 0);
            if (node2.getNodeName().equals("sf")) {
                string = node2.getNodeValue();
                continue;
            }
            if (node2.getNodeName().equals("wait")) {
                string2 = node2.getNodeValue();
                continue;
            }
            if (!node2.getNodeName().equals("transaction")) continue;
            string3 = node2.getNodeValue();
        }
        if (string == null) {
            string = "------";
        }
        bl = string2.toUpperCase().equals("TRUE");
        int n = 0;
        if (string3.length() > 0) {
            n = Integer.parseInt(string3);
        }
        SECSMessage sECSMessage = new SECSMessage(string, bl, n);
        NodeList nodeList = node.getChildNodes();
        int n2 = nodeList != null ? nodeList.getLength() : 0;
        for (int i = 0; i < n2; ++i) {
            Object object;
            Node node3 = nodeList.item(i);
            if (node3.getNodeType() != 1) continue;
            if (node3.getNodeName().equals("secs:list")) {
                object = new SECSList();
                sECSMessage.set((SECSList)object);
                XmlMessage.setListNode(node3, (SECSList)object);
                continue;
            }
            if (!node3.getNodeName().equals("secs:item")) continue;
            object = XmlMessage.parseItemNode(node3);
            sECSMessage.set((SECSItem)object);
        }
        return sECSMessage;
    }

    private static SECSItem parseItemNode(Node node) throws SECSException {
        Object object;
        String string = "";
        String string2 = "";
        String string3 = "";
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = namedNodeMap != null ? namedNodeMap.getLength() : 0;
        for (int i = 0; i < n; ++i) {
            object = namedNodeMap.item(i);
            if (object.getNodeName().equals("name")) {
                string2 = object.getNodeValue();
                continue;
            }
            if (object.getNodeName().equals("type")) {
                string3 = object.getNodeValue();
                continue;
            }
            if (!object.getNodeName().equals("comment")) continue;
            String string4 = object.getNodeValue();
        }
        Node node2 = node.getFirstChild();
        if (node2 != null) {
            if (node2.getNodeType() == 3) {
                string = node2.getNodeValue();
            } else if (node2.getNodeType() == 1) {
                string = node2.getNodeValue();
            } else if (node2.getNodeType() == 4 && (string3.equals("ascii") || string3.equals("jis") || string3.equals("utf-8"))) {
                string = node2.getNodeValue();
            }
        }
        object = new SECSItem(string2, string3, string);
        return object;
    }

    private static SECSItem parseItemList(Node node) throws SECSException {
        Object object;
        String string = "";
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = namedNodeMap != null ? namedNodeMap.getLength() : 0;
        for (int i = 0; i < n; ++i) {
            object = namedNodeMap.item(i);
            if (!object.getNodeName().equals("name")) continue;
            string = object.getNodeValue();
        }
        ArrayList<SECSItem> arrayList = new ArrayList<SECSItem>();
        object = node.getChildNodes();
        int n2 = object != null ? object.getLength() : 0;
        for (int i = 0; i < n2; ++i) {
            Node node2 = object.item(i);
            if (node2.getNodeType() != 1) continue;
            SECSItem sECSItem = XmlMessage.parseItemNode(node2);
            arrayList.add(sECSItem);
        }
        SECSItem sECSItem = new SECSItem(string, arrayList);
        return sECSItem;
    }

    private static void setListNode(Node node, SECSList sECSList) throws SECSException {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList != null ? nodeList.getLength() : 0;
        for (int i = 0; i < n; ++i) {
            Object object;
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            if (node2.getNodeName().equals("secs:list")) {
                object = new SECSList();
                sECSList.add((MutableTreeNode)object);
                XmlMessage.setListNode(node2, (SECSList)object);
                continue;
            }
            if (node2.getNodeName().equals("secs:item")) {
                object = XmlMessage.parseItemNode(node2);
                sECSList.add((SECSItem)object);
                continue;
            }
            if (!node2.getNodeName().equals("secs:itemlist")) continue;
            object = XmlMessage.parseItemList(node2);
            sECSList.add((SECSItem)object);
        }
    }

    public SECSMessage makeMessage(String string) throws SECSException {
        Node node = (Node)this.get(string);
        if (node == null) {
            return null;
        }
        return XmlMessage.parseMessageElementNode(node);
    }

    public void dump() {
        try {
            Iterator iterator = this.values().iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                SECSMessage sECSMessage = XmlMessage.parseMessageElementNode(node);
                sECSMessage.dump();
            }
        }
        catch (SECSException sECSException) {
            System.err.println("error: Parse error occurred - " + sECSException.getMessage());
            sECSException.printStackTrace(System.err);
        }
    }

    public static void main(String[] stringArray) {
        XmlMessage xmlMessage = new XmlMessage();
        if (stringArray.length > 0) {
            xmlMessage.open(stringArray[0]);
        } else {
            xmlMessage.open("testResponse.xml");
        }
        xmlMessage.dump();
    }
}

