/*
 * Decompiled with CFR 0.152.
 */
package com.jyugem.secs;

public final class UInteger
extends Number
implements Comparable {
    public static final long MIN_VALUE = 0L;
    public static final long MAX_VALUE = 0xFFFFFFFFL;
    private long value;

    public UInteger(UInteger uInteger) {
        this.value = uInteger.value;
    }

    public UInteger(int n) {
        this.value = n;
    }

    public UInteger(String string) throws NumberFormatException {
        this.value = UInteger.parseUInteger(string);
    }

    public static String toString(int n) {
        return Integer.toString(n);
    }

    public static int parseUInteger(String string) throws NumberFormatException {
        return UInteger.parseUInteger(string, 16);
    }

    public static int parseUInteger(String string, int n) throws NumberFormatException {
        long l = Long.parseLong(string, n);
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new NumberFormatException();
        }
        return (int)l;
    }

    public static UInteger valueOf(String string, int n) throws NumberFormatException {
        return new UInteger(UInteger.parseUInteger(string, n));
    }

    public static UInteger valueOf(String string) throws NumberFormatException {
        return UInteger.valueOf(string, 10);
    }

    public static UInteger decode(String string) throws NumberFormatException {
        UInteger uInteger;
        int n = 10;
        int n2 = 0;
        boolean bl = false;
        if (string.startsWith("-")) {
            bl = true;
            ++n2;
        }
        if (string.startsWith("0x", n2) || string.startsWith("0X", n2)) {
            n2 += 2;
            n = 16;
        } else if (string.startsWith("#", n2)) {
            ++n2;
            n = 16;
        } else if (string.startsWith("0", n2) && string.length() > n2 + 1) {
            ++n2;
            n = 8;
        }
        if (string.startsWith("-", n2)) {
            throw new NumberFormatException("Negative sign in wrong position");
        }
        try {
            uInteger = UInteger.valueOf(string.substring(n2), n);
            uInteger = bl ? new UInteger(-uInteger.intValue()) : uInteger;
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = "";
            if (bl) {
                string2 = "-";
            }
            string2 = string2 + string.substring(n2);
            uInteger = UInteger.valueOf(string2, n);
        }
        return uInteger;
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return Long.toString(this.value, 10);
    }

    public boolean equals(Object object) {
        if (object instanceof UInteger) {
            return this.value == (long)((UInteger)object).intValue();
        }
        return false;
    }

    public int compareTo(UInteger uInteger) {
        return this.value < uInteger.value ? -1 : (this.value == uInteger.value ? 0 : 1);
    }

    public int compareTo(Object object) {
        return this.compareTo((UInteger)object);
    }
}

