/*
 * Decompiled with CFR 0.152.
 */
package com.jyugem.secs;

import com.jyugem.secs.MessageMaker;
import com.jyugem.secs.SECSException;
import com.jyugem.secs.SECSItem;
import com.jyugem.secs.SECSMessage;
import com.jyugem.secs.SECSTime;
import com.jyugem.secs.XmlMessage;

public class SECSResponse
implements MessageMaker {
    XmlMessage m_messages;
    String m_primary;
    String m_secondary;

    SECSResponse(String string) {
        this.m_secondary = string;
        int n = SECSMessage.toStreamNumber(string);
        this.m_primary = SECSMessage.toStreamName(n - 1);
    }

    SECSResponse(String string, XmlMessage xmlMessage) {
        this.m_secondary = string;
        int n = SECSMessage.toStreamNumber(string);
        this.m_primary = SECSMessage.toStreamName(n - 1);
        this.m_messages = xmlMessage;
    }

    public SECSMessage make(SECSMessage sECSMessage) {
        try {
            SECSMessage sECSMessage2 = this.m_messages.makeMessage(this.m_secondary);
            sECSMessage2.transaction(sECSMessage.transaction());
            return sECSMessage2;
        }
        catch (SECSException sECSException) {
            System.err.println("error: Can't make response:" + this.m_secondary);
            this.m_messages.dump();
            return null;
        }
    }

    public static class S2F18
    extends SECSResponse {
        S2F18() {
            super("S2F18");
        }

        public SECSMessage make(SECSMessage sECSMessage) {
            SECSMessage sECSMessage2 = new SECSMessage("S2F18");
            SECSItem sECSItem = new SECSItem("TIME", SECSTime.get());
            sECSMessage2.set(sECSItem);
            sECSMessage2.transaction(sECSMessage.transaction());
            return sECSMessage2;
        }
    }
}

