/*
 * Decompiled with CFR 0.152.
 */
package com.jyugem.secs;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class SECSConfigurator {
    public static boolean m_equipment = false;
    static String configFileName = "secs.properties";
    static String m_secsFile;
    static String m_msgFile;
    static String m_protocol;
    static int m_devid;
    static String m_ip;
    static int m_port;
    static int m_baudrate;
    static int m_mode;

    public void configure() {
        this.configure(configFileName);
    }

    public void configure(String string) {
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("Could not read configuration file [" + string + "].");
            return;
        }
        SECSConfigurator.configure(properties);
    }

    public static void configure(Properties properties) {
        String string;
        m_secsFile = properties.getProperty("file.secs", "secs.xml");
        m_msgFile = properties.getProperty("file.response", "gemMessage.xml");
        m_protocol = properties.getProperty("secs.protocol", "HSMS");
        String string2 = properties.getProperty("secs.role", "HOST");
        m_equipment = !string2.equals("HOST");
        String string3 = properties.getProperty("secs.devid", "1");
        m_devid = Integer.parseInt(string3);
        m_ip = properties.getProperty("secs.hsms.ip", "127.0.0.1");
        String string4 = properties.getProperty("secs.comm.baudrate", "9600");
        m_baudrate = Integer.parseInt(string4);
        if (m_protocol.equals("HSMS")) {
            string = properties.getProperty("secs.hsms.port", "5000");
            m_port = Integer.parseInt(string);
        } else {
            string = properties.getProperty("secs.comm.port", "1");
            m_port = Integer.parseInt(string);
        }
        string = properties.getProperty("secs.mode", "ACTIVE");
        m_mode = string.equals("PASSIVE") ? 1 : 0;
    }

    public String getSecsXmlFile() {
        return m_secsFile;
    }

    public String getMessageFile() {
        return m_msgFile;
    }

    public int getDeviceID() {
        return m_devid;
    }

    public boolean isHSMS() {
        return m_protocol.equals("HSMS");
    }

    public boolean isEquipment() {
        return m_equipment;
    }

    public boolean isHost() {
        return !m_equipment;
    }

    public String getIPAddress() {
        return m_ip;
    }

    public int getPort() {
        return m_port;
    }

    public int getBaudrate() {
        return m_baudrate;
    }

    public int getMode() {
        return m_mode;
    }

    public static void main(String[] stringArray) {
        SECSConfigurator sECSConfigurator = new SECSConfigurator();
        sECSConfigurator.configure(configFileName);
        System.out.println("SECS Format : " + m_secsFile);
        System.out.println("Device ID : " + m_devid);
        System.out.println("Protocol : " + m_protocol);
        System.out.println("Equipment : " + m_equipment);
        System.out.println("IP Address : " + m_ip);
        System.out.println("Connect mode : " + m_mode);
    }
}

