/*
 * Decompiled with CFR 0.152.
 */
package com.jyugem.jsunit.tfw;

import com.jyugem.jsunit.tfw.SECSTestCase;
import com.jyugem.jsunit.tfw.SECSTestManager;
import com.jyugem.secs.SECSException;
import com.jyugem.secs.SECSMessage;
import com.jyugem.secs.XmlMessage;
import java.util.ArrayList;
import org.w3c.dom.Node;

public abstract class TestPair {
    public static int NOP = 0;
    public static int PASS = 1;
    public static int XPASS = 2;
    public static int SELF = 0;
    public static int RECEIVED = 1;
    public static int MATCH = 0;
    public static int CONTAIN = 1;
    public static int NOT_MATCH = 2;
    public static int NOT_CONTAIN = 3;
    SECSTestManager m_manager = null;
    ArrayList m_pairs = new ArrayList();

    public void init() {
        Pair pair = new Pair();
        this.m_pairs.add(pair);
    }

    public void setManager(SECSTestManager sECSTestManager) {
        this.m_manager = sECSTestManager;
    }

    public void add(String string, Node node) {
        Pair pair = new Pair(string, node);
        this.m_pairs.add(pair);
    }

    public void add(String string, boolean bl) {
        Pair pair = new Pair(string, bl);
        this.m_pairs.add(pair);
    }

    public void set(String string, Node node) {
        if (this.m_pairs.isEmpty()) {
            Pair pair = new Pair(string, node);
            this.m_pairs.add(pair);
        } else {
            Pair pair = (Pair)this.m_pairs.get(this.m_pairs.size() - 1);
            pair.m_msgStr = string;
            pair.m_message = node;
            pair.m_default = false;
        }
    }

    public void set(String string, boolean bl) {
        if (this.m_pairs.isEmpty()) {
            Pair pair = new Pair(string, bl);
            this.m_pairs.add(pair);
        } else {
            Pair pair = (Pair)this.m_pairs.get(this.m_pairs.size() - 1);
            pair.m_msgStr = string;
            pair.m_default = bl;
            pair.m_message = null;
        }
    }

    public void setLast(String string, int n, int n2, int n3) {
        Pair pair;
        if (this.m_pairs.isEmpty()) {
            pair = new Pair();
            this.m_pairs.add(pair);
        }
        pair = (Pair)this.m_pairs.get(this.m_pairs.size() - 1);
        pair.m_expect = string;
        pair.m_decision = n;
        pair.m_match = n2;
        pair.m_pattern = n3;
    }

    public int size() {
        return this.m_pairs.size();
    }

    public boolean isMatch() {
        return ((Pair)this.m_pairs.get((int)0)).m_match == MATCH;
    }

    public int getMatch() {
        return ((Pair)this.m_pairs.get((int)0)).m_match;
    }

    public int getDecision() {
        return ((Pair)this.m_pairs.get((int)0)).m_decision;
    }

    public String getExpect() {
        return ((Pair)this.m_pairs.get((int)0)).m_expect;
    }

    public SECSMessage getMessage() {
        return ((Pair)this.m_pairs.get(0)).getMessage();
    }

    public boolean isMatch(int n) {
        return ((Pair)this.m_pairs.get((int)n)).m_match == MATCH;
    }

    public int getMatch(int n) {
        return ((Pair)this.m_pairs.get((int)n)).m_match;
    }

    public int getDecision(int n) {
        return ((Pair)this.m_pairs.get((int)n)).m_decision;
    }

    public SECSMessage getMessage(int n) {
        return ((Pair)this.m_pairs.get(n)).getMessage();
    }

    public String getExpect(int n) {
        return ((Pair)this.m_pairs.get((int)n)).m_expect;
    }

    public String toXmlString(boolean bl) {
        String string = "";
        int n = this.m_pairs.size();
        if (n == 1) {
            Pair pair = (Pair)this.m_pairs.get(0);
            string = string + pair.toXmlString(bl);
        } else {
            string = string + "<secs:expects>\n";
            for (int i = 0; i < n; ++i) {
                Pair pair = (Pair)this.m_pairs.get(i);
                string = string + pair.toXmlString(bl);
            }
            string = string + "</secs:expects>\n";
        }
        return string;
    }

    protected class Pair {
        protected String m_expect = null;
        protected Node m_message = null;
        protected String m_msgStr = null;
        protected boolean m_default = false;
        protected int m_decision = PASS;
        protected int m_match = MATCH;
        protected int m_pattern = SELF;

        public Pair() {
        }

        public Pair(String string, boolean bl) {
            this.m_msgStr = string;
            this.m_default = bl;
        }

        public Pair(String string, Node node) {
            this.m_msgStr = string;
            this.m_message = node;
        }

        int getDecision() {
            return this.m_decision;
        }

        int getMatch() {
            return this.m_match;
        }

        SECSMessage getMessage() {
            try {
                if (this.m_default) {
                    Node node = (Node)TestPair.this.m_manager.getDefaultMessages().get(this.m_msgStr);
                    return XmlMessage.parseMessageElementNode(node);
                }
                if (this.m_message != null) {
                    return XmlMessage.parseMessageElementNode(this.m_message);
                }
            }
            catch (SECSException sECSException) {
                // empty catch block
            }
            return null;
        }

        String getExpect() {
            if (this.m_pattern == RECEIVED) {
                return SECSTestCase.getResentReceived();
            }
            return this.m_expect;
        }

        String toXmlString(boolean bl) {
            String[] stringArray = new String[]{"NOP", "PASS", "XPASS"};
            String[] stringArray2 = new String[]{"MATCH", "CONTAIN", "NOT-MATCH", "NOT-CONTAIN"};
            String string = "";
            if (this.m_msgStr != null) {
                string = string + "<secs:send sf=\"" + this.m_msgStr + "\" body=\"";
                string = string + (this.m_default ? "DEFAULT\">\n" : "THIS\">\n");
            }
            String string2 = "";
            if (this.m_expect != null) {
                string2 = string2 + "<secs:expect match=\"" + stringArray2[this.m_match] + "";
                if (this.m_pattern == RECEIVED) {
                    string2 = string2 + "\" pattern=\"RECEIVED\">\n";
                } else {
                    string2 = string2 + "\" pattern=\"THIS\">\n";
                    string2 = string2 + "<![CDATE[" + this.m_expect + "]]>\n";
                }
                string2 = string2 + "</secs:expect>\n";
            }
            String string3 = "";
            if (bl) {
                string3 = string3 + string;
                string3 = string3 + string2;
            } else {
                string3 = string3 + string2;
                string3 = string3 + string;
            }
            return string3;
        }
    }
}

