/*
 * Decompiled with CFR 0.152.
 */
package com.jyugem.jsunit.gui;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import junit.extensions.TestDecorator;
import junit.framework.Test;
import junit.framework.TestSuite;

class TestTreeModel
implements TreeModel {
    private Test fRoot;
    private Vector fModelListeners = new Vector();
    private Hashtable fFailures = new Hashtable();
    private Hashtable fErrors = new Hashtable();
    private Hashtable fRunTests = new Hashtable();

    public TestTreeModel(Test test) {
        this.fRoot = test;
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        if (!this.fModelListeners.contains(treeModelListener)) {
            this.fModelListeners.addElement(treeModelListener);
        }
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.fModelListeners.removeElement(treeModelListener);
    }

    public int findTest(Test test, Test test2, Vector vector) {
        if (test.equals(test2)) {
            return 0;
        }
        TestSuite testSuite = this.isTestSuite(test2);
        for (int i = 0; i < this.getChildCount(test2); ++i) {
            Test test3 = testSuite.testAt(i);
            int n = this.findTest(test, test3, vector);
            if (n < 0) continue;
            vector.insertElementAt(test2, 0);
            if (vector.size() == 1) {
                return i;
            }
            return n;
        }
        return -1;
    }

    public void fireNodeChanged(TreePath treePath, int n) {
        int[] nArray = new int[]{n};
        Object[] objectArray = new Object[]{this.getChild(treePath.getLastPathComponent(), n)};
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, objectArray);
        Enumeration enumeration = this.fModelListeners.elements();
        while (enumeration.hasMoreElements()) {
            TreeModelListener treeModelListener = (TreeModelListener)enumeration.nextElement();
            treeModelListener.treeNodesChanged(treeModelEvent);
        }
    }

    public Object getChild(Object object, int n) {
        TestSuite testSuite = this.isTestSuite(object);
        if (testSuite != null) {
            return testSuite.testAt(n);
        }
        return null;
    }

    public int getChildCount(Object object) {
        TestSuite testSuite = this.isTestSuite(object);
        if (testSuite != null) {
            return testSuite.testCount();
        }
        return 0;
    }

    public int getIndexOfChild(Object object, Object object2) {
        TestSuite testSuite = this.isTestSuite(object);
        if (testSuite != null) {
            int n = 0;
            Enumeration enumeration = testSuite.tests();
            while (enumeration.hasMoreElements()) {
                if (object2.equals((Test)enumeration.nextElement())) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public Object getRoot() {
        return this.fRoot;
    }

    public boolean isLeaf(Object object) {
        return this.isTestSuite(object) == null;
    }

    TestSuite isTestSuite(Object object) {
        if (object instanceof TestSuite) {
            return (TestSuite)object;
        }
        if (object instanceof TestDecorator) {
            Test test = ((TestDecorator)object).getTest();
            return this.isTestSuite(test);
        }
        return null;
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
        System.out.println("TreeModel.valueForPathChanged: not implemented");
    }

    void addFailure(Test test) {
        this.fFailures.put(test, test);
    }

    void addError(Test test) {
        this.fErrors.put(test, test);
    }

    void addRunTest(Test test) {
        this.fRunTests.put(test, test);
    }

    boolean wasRun(Test test) {
        return this.fRunTests.get(test) != null;
    }

    boolean isError(Test test) {
        return this.fErrors != null && this.fErrors.get(test) != null;
    }

    boolean isFailure(Test test) {
        return this.fFailures != null && this.fFailures.get(test) != null;
    }

    void resetResults() {
        this.fFailures = new Hashtable();
        this.fRunTests = new Hashtable();
        this.fErrors = new Hashtable();
    }
}

