/*
 * Decompiled with CFR 0.152.
 */
package com.jyugem.jsunit.gui;

import java.awt.Component;
import java.awt.Font;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import junit.framework.TestFailure;
import junit.runner.BaseTestRunner;
import junit.runner.FailureDetailView;

public class DefaultFailureDetailView
implements FailureDetailView {
    JList fList;

    public Component getComponent() {
        if (this.fList == null) {
            this.fList = new JList(new StackTraceListModel());
            this.fList.setFont(new Font("Dialog", 0, 12));
            this.fList.setSelectionMode(0);
            this.fList.setVisibleRowCount(5);
            this.fList.setCellRenderer(new StackEntryRenderer());
        }
        return this.fList;
    }

    public void showFailure(TestFailure testFailure) {
        this.getModel().setTrace(BaseTestRunner.getFilteredTrace((String)testFailure.trace()));
    }

    public void clear() {
        this.getModel().clear();
    }

    private StackTraceListModel getModel() {
        return (StackTraceListModel)this.fList.getModel();
    }

    static class StackEntryRenderer
    extends DefaultListCellRenderer {
        StackEntryRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = ((String)object).replace('\t', ' ');
            Component component = super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            this.setText(string);
            this.setToolTipText(string);
            return component;
        }
    }

    static class StackTraceListModel
    extends AbstractListModel {
        private Vector fLines = new Vector(20);

        StackTraceListModel() {
        }

        public Object getElementAt(int n) {
            return this.fLines.elementAt(n);
        }

        public int getSize() {
            return this.fLines.size();
        }

        public void setTrace(String string) {
            this.scan(string);
            this.fireContentsChanged(this, 0, this.fLines.size());
        }

        public void clear() {
            this.fLines.removeAllElements();
            this.fireContentsChanged(this, 0, this.fLines.size());
        }

        private void scan(String string) {
            this.fLines.removeAllElements();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r", false);
            while (stringTokenizer.hasMoreTokens()) {
                this.fLines.add(stringTokenizer.nextToken());
            }
        }
    }
}

