#
# import dxf file.
# $Id: dxf_mod.py 934 2006-06-27 22:22:56Z $
#
# Author: nemo
#
from math import sin, cos, tan, radians, fabs
from qcad import currentGraphic, Graphic, Vector, Line, LineData, Arc, ArcData, Point, PointData, Polyline, PolylineData, Circle, CircleData, zoomAuto, redraw

RoundOff = 0.001
graphic = currentGraphic()	# current document

def samePoint(pt1, pt2):
	if fabs(pt1[0]-pt2[0]) <= RoundOff and fabs(pt1[1]-pt2[1]) <= RoundOff and fabs(pt1[2]-pt2[2]) <= RoundOff:
		return 'true'
	return 'false'

class	DXF_Module:
	def __init__(self, name):
		self.Scale	= 1.0
		self.name = name

	def repaint(self):
		redraw()

	def zoom(self):
		zoomAuto()

	def polyline(self, data):
		global graphic
		for i in range(len(data)):
			for j in range(len(data[i])):
				data[i][j] *= self.Scale

#		d = PolylineData(Vector(0,0),
#					Vector(0,0),0x0) #0-->opne 1-->close
#		pline = Polyline(graphic, d)
#		setEntityAttributes(pline, attributes)
#		graphic.addEntity(pline)

#		for i in range(len(data)-1):
#			pline.addVertex(Vector(data[i][0], data[i][1]), 0.0, 0x0) #data.bulge 0 == line
		for i in range(len(data)-1):
			d = [data[i][0], data[i][1], 0.0, data[i+1][0], data[i+1][1], 0.0]
			self.line(d) #data.bulge 0 == line
		if samePoint(data[0], data[-1])=='false':
			d = [data[0][0], data[0][1], 0.0, data[-1][0], data[-1][1], 0.0]
			self.line(d) #data.bulge 0 == line


	def solid(self, data):
		global graphic
#		for i in range(len(data)):
#			for j in range(len(data[i])):
#				data[i][j] *= self.Scale
#		SolidData d(Vector(0),
#						  Vector(0),
#						  data[2]&0x1)
#		sld = Solid(graphic, d)
#		graphic.addEntity(sld)
#		if samePoint(data[0], data[-1])=='false':
#		e = me.addEdge(me.verts[-1], me.verts[0])
		data.append(data[0])
		self.polyline(data)

	#
	# Arc
	#
	def arc(self, data):
		global graphic

		arc = Arc(graphic,
					ArcData(Vector(data[0], data[1]),		# center
					data[3],							# radius
					data[4], data[5],			# start- / end angle
					0))							# counter clock wise
		graphic.addEntity(arc)

	#
	# Circle
	#
	def circle(self, data):
		global graphic

		cir = Circle(graphic,
					CircleData(Vector(data[0], data[1]),		# center
					data[3]))							# radius
		graphic.addEntity(cir)

	#
	# Line
	#
	def line(self, data):
		global graphic
		line = Line(graphic, LineData(Vector(data[0], data[1]), Vector(data[3], data[4])))
		graphic.addEntity(line)

	#
	# Point
	#
	def point(self, data):
		global graphic

		point = Point(graphic, PointData(Vector(data[0], data[1])))
		graphic.addEntity(point)
