package junkutil.gui;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import javax.swing.JDialog;

/**
 * JDialogpNX
 * @author Hiroyuki Shiota
 */
public class LzDialog extends JDialog {
	public LzDialog(Frame owner, boolean modal) {
		super(owner, modal);
	}
	
	public LzDialog(Frame owner, String title, int width, int height) {
		this(owner, title, width, height, false);
	}

	public LzDialog(Frame owner, String title, int width, int height, boolean modal) {
		super(owner, modal);
		setSize(width, height);
		if (title != null) setTitle(title);
	}
	
	public LzDialog(Dialog owner, boolean modal) {
		super(owner, modal);
	}
	
	public LzDialog(Dialog owner, String title, int width, int height) {
		this(owner, title, width, height, false);
	}

	public LzDialog(Dialog owner, String title, int width, int height, boolean modal) {
		super(owner, modal);
		setSize(width, height);
		if (title != null) setTitle(title);
	}

	private KeyAdapter escKeyAdapter = new KeyAdapter() {
		public void keyPressed(KeyEvent e) {
			super.keyPressed(e);
			if (e.getKeyCode() == KeyEvent.VK_ESCAPE) {
				dispose();
			}
		}
	};
	
	public void setEscapeToDispose(boolean b) {
		if (b) {
			KeyListener [] list = getKeyListeners();
			for (int i = 0; i < list.length; i++) {
				if (list[i] == escKeyAdapter) return;
			}
			addKeyListener(escKeyAdapter);
		} else {
			removeKeyListener(escKeyAdapter);
		}
	}
}
