/*
 * Decompiled with CFR 0.152.
 */
package junkutil.excel;

import java.awt.Font;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class POIUtil {
    private HSSFWorkbook workbook;
    private HSSFSheet sheet;
    private HSSFCellStyle style;
    private HSSFFont selectedFont;
    private Font baseFont;
    int fontSize;

    public POIUtil() {
        this.baseFont = new Font("\uff2d\uff33 \u30b4\u30b7\u30c3\u30af", 0, 11);
    }

    public POIUtil(Font font) {
        this.baseFont = font;
    }

    public void create() {
        this.workbook = new HSSFWorkbook();
        this.initFont();
        this.setFont(this.baseFont);
    }

    public void read(File file) throws IOException {
        BufferedInputStream bufInput = null;
        try {
            bufInput = new BufferedInputStream(new FileInputStream(file));
            POIFSFileSystem fileSys = new POIFSFileSystem((InputStream)bufInput);
            this.workbook = new HSSFWorkbook(fileSys);
            this.initFont();
            this.setFont(this.baseFont);
            if (this.getNumberOfSheets() > 0) {
                this.selectSheet(0);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (bufInput != null) {
                    bufInput.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void write(File file) throws IOException {
        FilterOutputStream bufOutput = null;
        try {
            bufOutput = new BufferedOutputStream(new FileOutputStream(file));
            this.workbook.write((OutputStream)bufOutput);
            ((BufferedOutputStream)bufOutput).flush();
            bufOutput.close();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                if (bufOutput != null) {
                    bufOutput.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public HSSFWorkbook getWorkbook() {
        return this.workbook;
    }

    public HSSFSheet getSheet() {
        return this.sheet;
    }

    public void selectSheet(int i) {
        this.sheet = this.workbook.getSheetAt(i);
    }

    public int createSheet(String name) {
        this.workbook.createSheet(name);
        return this.getNumberOfSheets() - 1;
    }

    public int createSheetAndSelect(String name) {
        this.workbook.createSheet(name);
        int sheetNo = this.getNumberOfSheets() - 1;
        this.selectSheet(sheetNo);
        return sheetNo;
    }

    public void removeSheet(int i) {
        this.workbook.removeSheetAt(i);
    }

    public int getNumberOfSheets() {
        return this.workbook.getNumberOfSheets();
    }

    public void setCellString(int iRow, int iCol, String strVal) {
        if (this.sheet == null) {
            throw new NullPointerException("Sheet is null");
        }
        HSSFCell cell = this.getCell(this.sheet, iRow, iCol);
        cell.setCellValue(strVal);
        this.setCellFont(cell);
    }

    public void setCellNumeric(int iRow, int iCol, double intVal) {
        if (this.sheet == null) {
            throw new NullPointerException("Sheet is null");
        }
        HSSFCell cell = this.getCell(this.sheet, iRow, iCol);
        cell.setCellValue(intVal);
        this.setCellFont(cell);
    }

    public String getCellString(int iRow, int iCol) {
        if (this.sheet == null) {
            throw new NullPointerException("Sheet is null");
        }
        HSSFCell cell = this.getCell(this.sheet, iRow, iCol);
        return cell.getStringCellValue();
    }

    public double getCellNumeric(int iRow, int iCol) {
        if (this.sheet == null) {
            throw new NullPointerException("Sheet is null");
        }
        HSSFCell cell = this.getCell(this.sheet, iRow, iCol);
        return cell.getNumericCellValue();
    }

    private HSSFCell getCell(HSSFSheet sheet, int iRow, int iCol) {
        HSSFCell cell;
        HSSFRow row = sheet.getRow(iRow);
        if (row == null) {
            row = sheet.createRow((int)((short)iRow));
        }
        if ((cell = row.getCell((short)iCol)) == null) {
            cell = row.createCell((short)iCol);
        }
        return cell;
    }

    private HSSFCell getCellOrNull(HSSFSheet sheet, int iRow, int iCol) {
        HSSFRow row = sheet.getRow(iRow);
        if (row == null) {
            return null;
        }
        HSSFCell cell = row.getCell((short)iCol);
        return cell;
    }

    private void setCellFont(HSSFCell cell) {
        HSSFCellStyle style = cell.getCellStyle();
        if (style != null) {
            style.setFont(this.selectedFont);
        } else {
            style = this.style;
            cell.setCellStyle(style);
        }
    }

    private void initFont() {
        for (int i = 0; i < this.workbook.getNumberOfFonts(); ++i) {
            HSSFFont font = this.workbook.getFontAt((short)i);
            font.setFontName(this.baseFont.getFontName());
            font.setFontHeightInPoints((short)this.baseFont.getSize());
        }
    }

    public void setFont(Font argFont) {
        this.selectedFont = this.workbook.createFont();
        this.selectedFont.setFontName(argFont.getFontName());
        this.selectedFont.setFontHeightInPoints((short)argFont.getSize());
        this.style = this.workbook.createCellStyle();
        this.style.setFont(this.selectedFont);
    }
}

